/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.utils;

import java.util.Collection;
import nl.teslanet.mule.connectors.coap.internal.utils.AppendableToString;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AttributeToStringStyle
extends ToStringStyle {
    private static final long serialVersionUID = 1L;
    protected static final int INDENT_SIZE = 3;
    private int spaces = 3;

    public AttributeToStringStyle() {
        this.setUseIdentityHashCode(false);
        this.setUseShortClassName(true);
        this.resetIndent();
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, boolean[] array) {
        this.indent();
        super.appendDetail(buffer, fieldName, array);
        this.unIndent();
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, byte[] array) {
        this.indent();
        super.appendDetail(buffer, fieldName, array);
        this.unIndent();
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, char[] array) {
        this.indent();
        super.appendDetail(buffer, fieldName, array);
        this.unIndent();
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, double[] array) {
        this.indent();
        super.appendDetail(buffer, fieldName, array);
        this.unIndent();
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, float[] array) {
        this.indent();
        super.appendDetail(buffer, fieldName, array);
        this.unIndent();
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, short[] array) {
        this.indent();
        super.appendDetail(buffer, fieldName, array);
        this.unIndent();
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, int[] array) {
        this.indent();
        super.appendDetail(buffer, fieldName, array);
        this.unIndent();
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, long[] array) {
        this.indent();
        super.appendDetail(buffer, fieldName, array);
        this.unIndent();
    }

    public void appendDetail(StringBuffer buffer, String fieldName, Object value) {
        if (ClassUtils.isPrimitiveWrapper(value.getClass()) || String.class.equals(value.getClass())) {
            super.appendDetail(buffer, fieldName, value);
        } else if (value instanceof AppendableToString) {
            this.indent();
            ((AppendableToString)value).appendTo(this, buffer);
            this.appendEnd(buffer, value);
            this.unIndent();
        } else {
            this.indent();
            super.appendDetail(buffer, fieldName, value);
            this.unIndent();
        }
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Object[] array) {
        this.indent();
        super.appendDetail(buffer, fieldName, array);
        this.unIndent();
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Collection<?> coll) {
        this.indent();
        super.appendDetail(buffer, fieldName, coll.toArray());
        this.unIndent();
    }

    private void indent() {
        this.spaces += 3;
        this.resetIndent();
    }

    private void unIndent() {
        this.spaces -= 3;
        this.resetIndent();
    }

    private void resetIndent() {
        this.setContentStart(System.lineSeparator() + this.spacer(this.spaces - 3) + "{" + System.lineSeparator() + this.spacer(this.spaces));
        this.setArrayStart("[" + System.lineSeparator() + this.spacer(this.spaces));
        this.setArraySeparator("," + System.lineSeparator() + this.spacer(this.spaces));
        this.setContentEnd(System.lineSeparator() + this.spacer(this.spaces - 3) + "}");
        this.setArrayEnd(System.lineSeparator() + this.spacer(this.spaces - 3) + "]");
        this.setFieldSeparator("," + System.lineSeparator() + this.spacer(this.spaces));
    }

    private String spacer(int spaces) {
        return StringUtils.repeat((char)' ', (int)spaces);
    }
}

