/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config.dtls;

import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.VisitableConfig;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class DtlsServerParams
implements VisitableConfig {
    @Parameter
    @Optional(defaultValue="MANDATORY")
    @Summary(value="DTLS client authentication mode for certificate based cipher suites.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public AuthenticationMode clientAuthentication;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Enable server to use a session ID in order to support session resumption.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean serverUseSessionId = true;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Use server name indication.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean serverNameIndication = false;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Use a HELLO_VERIFY_REQUEST to protect against spoofing.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean helloVerifyRequest = true;

    @Override
    public void accept(ConfigVisitor visitor) throws ConfigException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DtlsServerParams rhs = (DtlsServerParams)obj;
        return new EqualsBuilder().append((Object)this.clientAuthentication, (Object)rhs.clientAuthentication).append(this.serverUseSessionId, rhs.serverUseSessionId).append(this.serverNameIndication, rhs.serverNameIndication).append(this.helloVerifyRequest, rhs.helloVerifyRequest).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 35).append((Object)this.clientAuthentication).append(this.serverUseSessionId).append(this.serverNameIndication).append(this.helloVerifyRequest).toHashCode();
    }

    public static enum AuthenticationMode {
        NONE,
        OPTIONAL,
        MANDATORY;

    }
}

