/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config.endpoint;

import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DefaultReplayFilter;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsClientAndServerRole;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsEndpointRole;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsMessageParams;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsParams;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsResponseMatching;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsRetransmissionParams;
import nl.teslanet.mule.connectors.coap.api.config.dtls.ReplayFilter;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.AbstractEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.security.SecurityParams;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@TypeDsl(allowInlineDefinition=true, allowTopLevelDefinition=true)
public class DTLSEndpoint
extends AbstractEndpoint {
    @Parameter
    @Optional
    @NullSafe(defaultImplementingType=DtlsClientAndServerRole.class)
    @Summary(value="The DTLS role of the endpoint.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="DTLS Endpoint role")
    public DtlsEndpointRole dtlsRole = null;
    @Parameter
    @Summary(value="The security parameters.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Encryption config")
    public SecurityParams securityParams = null;
    @Parameter
    @Optional(defaultValue="STRICT")
    @Summary(value="The DTLS response matcher defines the algorithm used to correlate responses to requests.")
    @Example(value="RELAXED")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public DtlsResponseMatching responseMatching = DtlsResponseMatching.STRICT;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public DtlsParams dtlsParams;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public DtlsMessageParams dtlsMessageParams;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public DtlsRetransmissionParams dtlsRetransmissionsParams;
    @Parameter
    @Optional
    @NullSafe(defaultImplementingType=DefaultReplayFilter.class)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public ReplayFilter replayFilter = null;

    public DTLSEndpoint() {
    }

    public DTLSEndpoint(String name) {
        super(name);
        this.securityParams = new SecurityParams();
        this.dtlsRole = new DtlsClientAndServerRole();
        this.dtlsParams = new DtlsParams();
        this.dtlsMessageParams = new DtlsMessageParams();
        this.dtlsRetransmissionsParams = new DtlsRetransmissionParams();
        this.replayFilter = new DefaultReplayFilter();
    }

    @Override
    public void accept(ConfigVisitor visitor) throws ConfigException {
        super.accept(visitor);
        visitor.visit(this);
        this.securityParams.accept(visitor);
        this.dtlsRole.accept(visitor);
        this.dtlsParams.accept(visitor);
        this.dtlsMessageParams.accept(visitor);
        this.dtlsRetransmissionsParams.accept(visitor);
        if (this.replayFilter != null) {
            this.replayFilter.accept(visitor);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DTLSEndpoint rhs = (DTLSEndpoint)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.dtlsRole, (Object)rhs.dtlsRole).append((Object)this.securityParams, (Object)rhs.securityParams).append((Object)this.responseMatching, (Object)rhs.responseMatching).append((Object)this.dtlsParams, (Object)rhs.dtlsParams).append((Object)this.dtlsMessageParams, (Object)rhs.dtlsMessageParams).append((Object)this.dtlsRetransmissionsParams, (Object)rhs.dtlsRetransmissionsParams).append((Object)this.replayFilter, (Object)rhs.replayFilter).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(15, 35).appendSuper(super.hashCode()).append((Object)this.dtlsRole).append((Object)this.securityParams).append((Object)this.responseMatching).append((Object)this.dtlsParams).append((Object)this.dtlsMessageParams).append((Object)this.responseMatching).append((Object)this.replayFilter).toHashCode();
    }
}

