/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.client;

import java.util.concurrent.atomic.AtomicBoolean;
import nl.teslanet.mule.connectors.coap.internal.client.CoapRequestBuilder;
import nl.teslanet.mule.connectors.coap.internal.client.ResponseProcessingStrategy;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidRequestCodeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalRequestException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUnkownOptionException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUriException;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.californium.core.CoapResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveRelation
implements CoapHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ObserveRelation.class.getCanonicalName());
    private final String observerName;
    private final CoapClient coapClient;
    private final CoapRequestBuilder requestBuilder;
    private final boolean defaultProactiveCancel;
    private final ResponseProcessingStrategy processor;
    private CoapObserveRelation coapRelation = null;
    private AtomicBoolean started = new AtomicBoolean(false);

    ObserveRelation(String observerName, CoapClient coapClient, CoapRequestBuilder requestBuilder, boolean proactiveCancel, ResponseProcessingStrategy processor) {
        this.observerName = observerName;
        this.coapClient = coapClient;
        this.requestBuilder = requestBuilder;
        this.defaultProactiveCancel = proactiveCancel;
        this.processor = processor;
    }

    public synchronized void start() {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.coapRelation = this.sendObserveRequest();
                LOGGER.info("{} has started.", (Object)this);
            }
            catch (InternalInvalidOptionValueException | InternalInvalidRequestCodeException | InternalRequestException | InternalUnkownOptionException | InternalUriException e) {
                LOGGER.error(String.format("%s failed to start observe relation with server.", this), (Throwable)e);
            }
        }
    }

    public synchronized void resume() {
        if (this.started.get()) {
            LOGGER.warn("{} trying to restore observe relation with server...", (Object)this);
            if (this.coapRelation != null) {
                if (this.coapRelation.isCanceled()) {
                    try {
                        this.coapRelation = this.sendObserveRequest();
                    }
                    catch (InternalInvalidOptionValueException | InternalInvalidRequestCodeException | InternalRequestException | InternalUnkownOptionException | InternalUriException e) {
                        LOGGER.error(String.format("%s observe request failed, cannot restore relation with server...", this), (Throwable)e);
                    }
                    if (this.coapRelation != null) {
                        LOGGER.info("{} observe request sent.", (Object)this);
                    } else {
                        LOGGER.error("{} failed to recreate relation with server.", (Object)this);
                    }
                } else if (this.coapRelation.reregister()) {
                    LOGGER.info("{} reregistered on server.", (Object)this);
                } else {
                    LOGGER.error("{} failed to reregister on server.", (Object)this);
                }
            }
        }
    }

    public synchronized void stop() {
        this.stop(null, null);
    }

    public synchronized void stop(Boolean proactiveCancel, Boolean confirmable) {
        if (this.started.compareAndSet(true, false)) {
            if (this.coapRelation != null) {
                if (confirmable != null) {
                    this.coapRelation.setConfirmable(confirmable.booleanValue());
                }
                if (proactiveCancel != null ? proactiveCancel != false : this.defaultProactiveCancel) {
                    this.coapRelation.proactiveCancel();
                } else {
                    this.coapRelation.reactiveCancel();
                }
                this.coapRelation = null;
            }
            LOGGER.info("{} has stopped.", (Object)this);
        }
    }

    public void onError() {
        try {
            this.processor.process(this.requestBuilder, null);
        }
        catch (InternalResponseException e) {
            LOGGER.error(String.format("%s error processing failed.", this), (Throwable)e);
        }
        this.resume();
    }

    public void onLoad(CoapResponse response) {
        try {
            this.processor.process(this.requestBuilder, response);
        }
        catch (InternalResponseException e) {
            LOGGER.error(String.format("%s notification processing failed.", this), (Throwable)e);
        }
    }

    private CoapObserveRelation sendObserveRequest() throws InternalInvalidRequestCodeException, InternalUriException, InternalRequestException, InternalInvalidOptionValueException, InternalUnkownOptionException {
        return this.coapClient.observe(this.requestBuilder.build(), (CoapHandler)this);
    }

    public String toString() {
        return this.observerName;
    }
}

