/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.client;

import java.io.InputStream;
import java.net.URI;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapResponseAttributes;
import nl.teslanet.mule.connectors.coap.internal.client.Client;
import nl.teslanet.mule.connectors.coap.internal.client.ObserveRelation;
import nl.teslanet.mule.connectors.coap.internal.client.ObserverConfig;
import nl.teslanet.mule.connectors.coap.internal.client.ResponseProcessor;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUriException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.StartException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="observer")
@MediaType(value="application/octet-stream", strict=false)
public class Observer
extends Source<InputStream, CoapResponseAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Observer.class.getCanonicalName());
    @Config
    private Client client;
    @ParameterGroup(name="Observer configuration")
    private ObserverConfig observerConfig;
    private ObserveRelation relation = null;
    private URI uri = null;

    public void onStart(SourceCallback<InputStream, CoapResponseAttributes> sourceCallback) throws MuleException {
        Client client = this.client;
        client.getClass();
        Client.CoapRequestBuilderImpl requestBuilder = new Client.CoapRequestBuilderImpl(client, this.observerConfig);
        String localAdress = this.client.getLocalAddress();
        try {
            this.uri = requestBuilder.buildResourceUri();
        }
        catch (InternalUriException e) {
            throw new StartException((Object)((Object)this) + " failed to start, invalid uri. ", e);
        }
        this.relation = new ObserveRelation(this.toString(), this.client.getCoapClient(), requestBuilder, this.client.activeObserveCancel(this.observerConfig.getObserveCancel()), (requestBuilder2, response) -> ResponseProcessor.processMuleFlow(localAdress, requestBuilder2, response, sourceCallback));
        this.relation.start();
        LOGGER.info("{} started.", (Object)this);
    }

    public void onStop() {
        if (this.relation != null) {
            this.relation.stop();
            this.relation = null;
        }
        LOGGER.info("{} stopped.", (Object)this);
    }

    public String toString() {
        return "CoAP Observer { " + this.client.getClientName() + "::" + this.uri + "(static) }";
    }
}

