/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.config;

import java.util.concurrent.TimeUnit;
import nl.teslanet.mule.connectors.coap.api.config.BlockwiseParams;
import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.ExchangeParams;
import nl.teslanet.mule.connectors.coap.api.config.LogHealthStatus;
import nl.teslanet.mule.connectors.coap.api.config.NotificationParams;
import nl.teslanet.mule.connectors.coap.api.config.SocketParams;
import nl.teslanet.mule.connectors.coap.api.config.TcpParams;
import nl.teslanet.mule.connectors.coap.api.config.TlsParams;
import nl.teslanet.mule.connectors.coap.api.config.UdpParams;
import nl.teslanet.mule.connectors.coap.api.config.congestion.BasicRto;
import nl.teslanet.mule.connectors.coap.api.config.congestion.Cocoa;
import nl.teslanet.mule.connectors.coap.api.config.congestion.CocoaStrong;
import nl.teslanet.mule.connectors.coap.api.config.congestion.LinuxRto;
import nl.teslanet.mule.connectors.coap.api.config.congestion.PeakhopperRto;
import nl.teslanet.mule.connectors.coap.api.config.deduplication.CropRotation;
import nl.teslanet.mule.connectors.coap.api.config.deduplication.Deduplicator;
import nl.teslanet.mule.connectors.coap.api.config.deduplication.MarkAndSweep;
import nl.teslanet.mule.connectors.coap.api.config.deduplication.PeersMarkAndSweep;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DatagramFilter;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DefaultReplayFilter;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsClientAndServerRole;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsClientParams;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsClientRole;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsMessageParams;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsParams;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsRetransmissionParams;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsServerParams;
import nl.teslanet.mule.connectors.coap.api.config.dtls.DtlsServerRole;
import nl.teslanet.mule.connectors.coap.api.config.dtls.ExtendedReplayFilter;
import nl.teslanet.mule.connectors.coap.api.config.dtls.NoReplayFilter;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.AbstractUDPEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.DTLSEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.midtracker.GroupedMidTracker;
import nl.teslanet.mule.connectors.coap.api.config.midtracker.MapBasedMidTracker;
import nl.teslanet.mule.connectors.coap.api.config.midtracker.NullMidTracker;
import nl.teslanet.mule.connectors.coap.api.config.security.ConnectionId;
import nl.teslanet.mule.connectors.coap.api.config.security.SecurityParams;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidDurationException;
import nl.teslanet.mule.connectors.coap.internal.utils.SecurityUtils;
import nl.teslanet.mule.connectors.coap.internal.utils.TimeUtils;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.TcpConfig;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;

public class ConfigurationVisitor
implements ConfigVisitor {
    private Configuration config = Configuration.createStandardWithoutFile();

    @Override
    public void visit(AbstractUDPEndpoint toVisit) {
        if (toVisit.strictResponseMatching) {
            this.config.set((BasicDefinition)CoapConfig.RESPONSE_MATCHING, (Object)CoapConfig.MatcherMode.STRICT);
        } else {
            this.config.set((BasicDefinition)CoapConfig.RESPONSE_MATCHING, (Object)CoapConfig.MatcherMode.RELAXED);
        }
    }

    @Override
    public void visit(DTLSEndpoint toVisit) {
        if (toVisit.responseMatching != null) {
            switch (toVisit.responseMatching) {
                case PRINCIPAL: {
                    this.config.set((BasicDefinition)CoapConfig.RESPONSE_MATCHING, (Object)CoapConfig.MatcherMode.PRINCIPAL);
                    break;
                }
                case PRINCIPAL_IDENTITY: {
                    this.config.set((BasicDefinition)CoapConfig.RESPONSE_MATCHING, (Object)CoapConfig.MatcherMode.PRINCIPAL_IDENTITY);
                    break;
                }
                case RELAXED: {
                    this.config.set((BasicDefinition)CoapConfig.RESPONSE_MATCHING, (Object)CoapConfig.MatcherMode.RELAXED);
                    break;
                }
                case STRICT: {
                    this.config.set((BasicDefinition)CoapConfig.RESPONSE_MATCHING, (Object)CoapConfig.MatcherMode.STRICT);
                }
            }
        }
    }

    @Override
    public void visit(DtlsServerRole toVisit) {
        this.config.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.SERVER_ONLY);
    }

    @Override
    public void visit(DtlsClientRole toVisit) {
        this.config.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.CLIENT_ONLY);
    }

    @Override
    public void visit(DtlsClientAndServerRole toVisit) {
        this.config.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.BOTH);
    }

    @Override
    public void visit(NoReplayFilter toVisit) {
        this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_ANTI_REPLAY_FILTER, (Object)false);
        this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER, (Object)0);
    }

    @Override
    public void visit(DefaultReplayFilter toVisit) {
        this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_ANTI_REPLAY_FILTER, (Object)true);
        this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER, (Object)0);
    }

    @Override
    public void visit(ExtendedReplayFilter toVisit) {
        this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_ANTI_REPLAY_FILTER, (Object)true);
        if (toVisit.extendedfilterWindow == null) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER, (Object)-1);
        } else {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER, (Object)Math.max(0, toVisit.extendedfilterWindow));
        }
    }

    @Override
    public void visit(BlockwiseParams toVisit) throws ConfigException {
        try {
            if (toVisit.preferredBlockSize != null) {
                this.config.set((BasicDefinition)CoapConfig.PREFERRED_BLOCK_SIZE, (Object)toVisit.preferredBlockSize);
            }
            if (toVisit.maxMessageSize != null) {
                this.config.set((BasicDefinition)CoapConfig.MAX_MESSAGE_SIZE, (Object)toVisit.maxMessageSize);
            }
            if (toVisit.maxResourceBodySize != null && toVisit.maxResourceBodySize > 0) {
                this.config.set((BasicDefinition)CoapConfig.MAX_RESOURCE_BODY_SIZE, (Object)toVisit.maxResourceBodySize);
            }
            if (toVisit.statusLifetime != null) {
                this.config.set(CoapConfig.BLOCKWISE_STATUS_LIFETIME, Long.valueOf(TimeUtils.toNanos(toVisit.statusLifetime)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.statusInterval != null) {
                this.config.set(CoapConfig.BLOCKWISE_STATUS_INTERVAL, Long.valueOf(TimeUtils.toNanos(toVisit.statusInterval)), TimeUnit.NANOSECONDS);
            }
            this.config.set((BasicDefinition)CoapConfig.BLOCKWISE_STRICT_BLOCK1_OPTION, (Object)toVisit.strictBlock1Option);
            this.config.set((BasicDefinition)CoapConfig.BLOCKWISE_STRICT_BLOCK2_OPTION, (Object)toVisit.strictBlock2Option);
            this.config.set((BasicDefinition)CoapConfig.BLOCKWISE_ENTITY_TOO_LARGE_AUTO_FAILOVER, (Object)toVisit.entityTooLargeFailover);
        }
        catch (InternalInvalidDurationException e) {
            throw new ConfigException("blockwise-params configuration error", e);
        }
    }

    @Override
    public void visit(ExchangeParams toVisit) throws ConfigException {
        try {
            if (toVisit.maxActivePeers != null) {
                this.config.set((BasicDefinition)CoapConfig.MAX_ACTIVE_PEERS, (Object)toVisit.maxActivePeers);
            }
            if (toVisit.maxPeerInactivityPeriod != null) {
                this.config.set(CoapConfig.MAX_PEER_INACTIVITY_PERIOD, Long.valueOf(TimeUtils.toNanos(toVisit.maxPeerInactivityPeriod)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.ackTimeout != null) {
                this.config.set(CoapConfig.ACK_TIMEOUT, Long.valueOf(TimeUtils.toNanos(toVisit.ackTimeout)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.maxAckTimeout != null) {
                this.config.set(CoapConfig.MAX_ACK_TIMEOUT, Long.valueOf(TimeUtils.toNanos(toVisit.maxAckTimeout)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.ackRandomFactor != null) {
                this.config.set((BasicDefinition)CoapConfig.ACK_INIT_RANDOM, (Object)toVisit.ackRandomFactor);
            }
            if (toVisit.ackTimeoutScale != null) {
                this.config.set((BasicDefinition)CoapConfig.ACK_TIMEOUT_SCALE, (Object)toVisit.ackTimeoutScale);
            }
            if (toVisit.maxRetransmit != null) {
                this.config.set((BasicDefinition)CoapConfig.MAX_RETRANSMIT, (Object)toVisit.maxRetransmit);
            }
            if (toVisit.exchangeLifetime != null) {
                this.config.set(CoapConfig.EXCHANGE_LIFETIME, Long.valueOf(TimeUtils.toNanos(toVisit.exchangeLifetime)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.nonLifetime != null) {
                this.config.set(CoapConfig.NON_LIFETIME, Long.valueOf(TimeUtils.toNanos(toVisit.nonLifetime)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.maxLatency != null) {
                this.config.set(CoapConfig.MAX_LATENCY, Long.valueOf(TimeUtils.toNanos(toVisit.maxLatency)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.maxTransmitWait != null) {
                this.config.set(CoapConfig.MAX_TRANSMIT_WAIT, Long.valueOf(TimeUtils.toNanos(toVisit.maxTransmitWait)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.maxResponseDelay != null) {
                this.config.set(CoapConfig.MAX_SERVER_RESPONSE_DELAY, Long.valueOf(TimeUtils.toNanos(toVisit.maxResponseDelay)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.nstart != null) {
                this.config.set((BasicDefinition)CoapConfig.NSTART, (Object)toVisit.nstart);
            }
            if (toVisit.tokenSizeLimit != null) {
                this.config.set((BasicDefinition)CoapConfig.TOKEN_SIZE_LIMIT, (Object)toVisit.tokenSizeLimit);
            }
            if (toVisit.multicastMidBase != null) {
                this.config.set((BasicDefinition)CoapConfig.MULTICAST_BASE_MID, (Object)toVisit.multicastMidBase);
            }
            if (toVisit.leisure != null) {
                this.config.set(CoapConfig.LEISURE, Long.valueOf(TimeUtils.toNanos(toVisit.leisure)), TimeUnit.NANOSECONDS);
            }
            this.config.set((BasicDefinition)CoapConfig.STRICT_EMPTY_MESSAGE_FORMAT, (Object)toVisit.strictEmptyMessageFormat);
            this.config.set((BasicDefinition)CoapConfig.USE_RANDOM_MID_START, (Object)toVisit.useRandomMidStart);
        }
        catch (InternalInvalidDurationException e) {
            throw new ConfigException("exchange-params configuration error", e);
        }
    }

    @Override
    public void visit(GroupedMidTracker toVisit) {
        this.config.set((BasicDefinition)CoapConfig.MID_TRACKER, (Object)CoapConfig.TrackerMode.GROUPED);
        if (toVisit.midTrackerGroups != null) {
            this.config.set((BasicDefinition)CoapConfig.MID_TRACKER_GROUPS, (Object)toVisit.midTrackerGroups);
        }
    }

    @Override
    public void visit(MapBasedMidTracker toVisit) {
        this.config.set((BasicDefinition)CoapConfig.MID_TRACKER, (Object)CoapConfig.TrackerMode.MAPBASED);
    }

    @Override
    public void visit(NullMidTracker toVisit) {
        this.config.set((BasicDefinition)CoapConfig.MID_TRACKER, (Object)CoapConfig.TrackerMode.NULL);
    }

    @Override
    public void visit(Deduplicator toVisit) {
        this.config.set((BasicDefinition)CoapConfig.DEDUPLICATOR_AUTO_REPLACE, (Object)toVisit.autoReplace);
    }

    @Override
    public void visit(CropRotation toVisit) throws ConfigException {
        try {
            this.config.set((BasicDefinition)CoapConfig.DEDUPLICATOR, (Object)"CROP_ROTATION");
            if (toVisit.cropRotationPeriod != null) {
                this.config.set(CoapConfig.CROP_ROTATION_PERIOD, Long.valueOf(TimeUtils.toNanos(toVisit.cropRotationPeriod)), TimeUnit.NANOSECONDS);
            }
        }
        catch (InternalInvalidDurationException e) {
            throw new ConfigException("crop-rotation configuration error", e);
        }
    }

    @Override
    public void visit(MarkAndSweep toVisit) throws ConfigException {
        try {
            this.config.set((BasicDefinition)CoapConfig.DEDUPLICATOR, (Object)"MARK_AND_SWEEP");
            if (toVisit.markAndSweepInterval != null) {
                this.config.set(CoapConfig.MARK_AND_SWEEP_INTERVAL, Long.valueOf(TimeUtils.toNanos(toVisit.markAndSweepInterval)), TimeUnit.NANOSECONDS);
            }
        }
        catch (InternalInvalidDurationException e) {
            throw new ConfigException("mark-and-sweep configuration error", e);
        }
    }

    @Override
    public void visit(PeersMarkAndSweep toVisit) {
        this.config.set((BasicDefinition)CoapConfig.DEDUPLICATOR, (Object)"PEERS_MARK_AND_SWEEP");
        if (toVisit.maxMessagesPerPeer != null) {
            this.config.set((BasicDefinition)CoapConfig.PEERS_MARK_AND_SWEEP_MESSAGES, (Object)toVisit.maxMessagesPerPeer);
        }
    }

    @Override
    public void visit(LogHealthStatus toVisit) throws ConfigException {
        try {
            if (toVisit.healthStatusInterval != null) {
                this.config.set(SystemConfig.HEALTH_STATUS_INTERVAL, Long.valueOf(TimeUtils.toNanos(toVisit.healthStatusInterval)), TimeUnit.NANOSECONDS);
            } else {
                this.config.set(SystemConfig.HEALTH_STATUS_INTERVAL, 600, TimeUnit.SECONDS);
            }
        }
        catch (InternalInvalidDurationException e) {
            throw new ConfigException("health status configuration error", e);
        }
    }

    @Override
    public void visit(BasicRto basicRto) {
        this.config.set((BasicDefinition)CoapConfig.CONGESTION_CONTROL_ALGORITHM, (Object)CoapConfig.CongestionControlMode.BASIC_RTO);
    }

    @Override
    public void visit(Cocoa cocoa) {
        this.config.set((BasicDefinition)CoapConfig.CONGESTION_CONTROL_ALGORITHM, (Object)CoapConfig.CongestionControlMode.COCOA);
    }

    @Override
    public void visit(CocoaStrong cocoaStrong) {
        this.config.set((BasicDefinition)CoapConfig.CONGESTION_CONTROL_ALGORITHM, (Object)CoapConfig.CongestionControlMode.COCOA_STRONG);
    }

    @Override
    public void visit(LinuxRto linuxRto) {
        this.config.set((BasicDefinition)CoapConfig.CONGESTION_CONTROL_ALGORITHM, (Object)CoapConfig.CongestionControlMode.LINUX_RTO);
    }

    @Override
    public void visit(PeakhopperRto peakhopperRto) {
        this.config.set((BasicDefinition)CoapConfig.CONGESTION_CONTROL_ALGORITHM, (Object)CoapConfig.CongestionControlMode.PEAKHOPPER_RTO);
    }

    @Override
    public void visit(UdpParams toVisit) {
        if (toVisit.receiverThreadCount != null) {
            this.config.set((BasicDefinition)UdpConfig.UDP_RECEIVER_THREAD_COUNT, (Object)toVisit.receiverThreadCount);
        }
        if (toVisit.senderThreadCount != null) {
            this.config.set((BasicDefinition)UdpConfig.UDP_SENDER_THREAD_COUNT, (Object)toVisit.senderThreadCount);
        }
        if (toVisit.datagramSize != null) {
            this.config.set((BasicDefinition)UdpConfig.UDP_DATAGRAM_SIZE, (Object)toVisit.datagramSize);
        }
        if (toVisit.outCapacity != null) {
            this.config.set((BasicDefinition)UdpConfig.UDP_CONNECTOR_OUT_CAPACITY, (Object)toVisit.outCapacity);
        }
    }

    @Override
    public void visit(TcpParams toVisit) {
        if (toVisit.tcpConnectTimeout != null) {
            this.config.set(TcpConfig.TCP_CONNECT_TIMEOUT, toVisit.tcpConnectTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (toVisit.tcpWorkerThreads != null) {
            this.config.set((BasicDefinition)TcpConfig.TCP_WORKER_THREADS, (Object)toVisit.tcpWorkerThreads);
        }
        if (toVisit.tcpConnectionIdleTimeout != null) {
            this.config.set(TcpConfig.TCP_CONNECTION_IDLE_TIMEOUT, toVisit.tcpConnectTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void visit(TlsParams toVisit) {
        if (toVisit.tlsHandshakeTimeout != null) {
            this.config.set(TcpConfig.TLS_HANDSHAKE_TIMEOUT, toVisit.tlsHandshakeTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (toVisit.secureSessionTimeout != null) {
            this.config.set(TcpConfig.TLS_SESSION_TIMEOUT, toVisit.secureSessionTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void visit(SecurityParams toVisit) throws ConfigException {
        this.config.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, (Object)toVisit.recommendedCipherSuitesOnly);
        this.config.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_CURVES_ONLY, (Object)toVisit.recommendedCurvesOnly);
        this.config.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_SIGNATURE_AND_HASH_ALGORITHMS_ONLY, (Object)toVisit.recommendedSignatureAndHashAlgorithmsOnly);
        if (toVisit.preselectedCipherSuites != null) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_PRESELECTED_CIPHER_SUITES, SecurityUtils.toCfCipherSuites(toVisit.preselectedCipherSuites));
        }
        if (toVisit.cipherSuites != null && !toVisit.cipherSuites.isEmpty()) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_CIPHER_SUITES, SecurityUtils.toCfCipherSuites(toVisit.cipherSuites));
        }
        if (toVisit.curves != null && !toVisit.curves.isEmpty()) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_CURVES, SecurityUtils.toCfCurves(toVisit.curves));
        }
        if (toVisit.signatureAlgorithms != null && !toVisit.signatureAlgorithms.isEmpty()) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_SIGNATURE_AND_HASH_ALGORITHMS, SecurityUtils.toCfSignatureAndHashAlgoritms(toVisit.signatureAlgorithms));
        }
        if (toVisit.certificateKeyAlgorithms != null && !toVisit.certificateKeyAlgorithms.isEmpty()) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_CERTIFICATE_KEY_ALGORITHMS, SecurityUtils.toCfCertificateKeyAlgorithms(toVisit.certificateKeyAlgorithms));
        }
        if (toVisit.extendedMasterSecretMode != null) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_EXTENDED_MASTER_SECRET_MODE, (Object)SecurityUtils.toCfExtendedMasterSecretMode(toVisit.extendedMasterSecretMode));
        }
        this.config.set((BasicDefinition)DtlsConfig.DTLS_TRUNCATE_CERTIFICATE_PATH_FOR_VALIDATION, (Object)toVisit.truncateCertificatePathForValidation);
    }

    @Override
    public void visit(ConnectionId toVisit) throws ConfigException {
        if (toVisit.connectionIdLength != null && toVisit.connectionIdLength > 0) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_CONNECTION_ID_LENGTH, (Object)toVisit.connectionIdLength);
        } else {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_CONNECTION_ID_LENGTH, (Object)0);
        }
        this.config.set((BasicDefinition)DtlsConfig.DTLS_UPDATE_ADDRESS_USING_CID_ON_NEWER_RECORDS, (Object)toVisit.updateAddressOnNewerRecords);
    }

    @Override
    public void visit(DtlsServerParams toVisit) throws ConfigException {
        this.config.set((BasicDefinition)DtlsConfig.DTLS_SERVER_USE_SESSION_ID, (Object)toVisit.serverUseSessionId);
        if (toVisit.clientAuthentication != null) {
            switch (toVisit.clientAuthentication) {
                case NONE: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.NONE);
                    break;
                }
                case OPTIONAL: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.WANTED);
                    break;
                }
                case MANDATORY: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.NEEDED);
                }
            }
        }
        this.config.set((BasicDefinition)DtlsConfig.DTLS_SERVER_USE_SESSION_ID, (Object)toVisit.serverUseSessionId);
        this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_SERVER_NAME_INDICATION, (Object)toVisit.serverNameIndication);
        this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_HELLO_VERIFY_REQUEST, (Object)toVisit.helloVerifyRequest);
    }

    @Override
    public void visit(DtlsClientParams toVisit) throws ConfigException {
        this.config.set((BasicDefinition)DtlsConfig.DTLS_VERIFY_SERVER_CERTIFICATES_SUBJECT, (Object)toVisit.verifyServerCertificateSubject);
        switch (toVisit.defaultHandshakeMode) {
            case NONE: {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_DEFAULT_HANDSHAKE_MODE, (Object)"none");
                break;
            }
            case AUTO: {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_DEFAULT_HANDSHAKE_MODE, (Object)"auto");
            }
        }
        this.config.set((BasicDefinition)DtlsConfig.DTLS_TRUNCATE_CLIENT_CERTIFICATE_PATH, (Object)toVisit.truncateClientCertificatePaths);
    }

    @Override
    public void visit(DtlsParams toVisit) throws ConfigException {
        try {
            if (toVisit.maxConnections != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_CONNECTIONS, (Object)toVisit.maxConnections);
            }
            if (toVisit.staleConnectionThreshold != null) {
                this.config.set(DtlsConfig.DTLS_STALE_CONNECTION_THRESHOLD, Long.valueOf(TimeUtils.toNanos(toVisit.staleConnectionThreshold)), TimeUnit.NANOSECONDS);
            }
            this.config.set((BasicDefinition)DtlsConfig.DTLS_REMOVE_STALE_DOUBLE_PRINCIPALS, (Object)toVisit.removeStaleDoublePrincipals);
            if (toVisit.outboundMsgCapacity != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_PENDING_OUTBOUND_JOBS, (Object)toVisit.outboundMsgCapacity);
            }
            if (toVisit.inboundMsgCapacity != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_PENDING_INBOUND_JOBS, (Object)toVisit.inboundMsgCapacity);
            }
            if (toVisit.dtlsReceiverThreadCount != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_RECEIVER_THREAD_COUNT, (Object)toVisit.dtlsReceiverThreadCount);
            }
            if (toVisit.dtlsConnectorThreadCount != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_CONNECTOR_THREAD_COUNT, (Object)toVisit.dtlsConnectorThreadCount);
            }
            if (toVisit.handshakeCapacity != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_PENDING_HANDSHAKE_RESULT_JOBS, (Object)toVisit.handshakeCapacity);
            }
            if (toVisit.handshakeRecordBufferSize != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_DEFERRED_INBOUND_RECORDS_SIZE, (Object)toVisit.handshakeRecordBufferSize);
            }
            if (toVisit.deferredMsgCapacity != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES, (Object)toVisit.deferredMsgCapacity);
            }
            if (toVisit.autoHandshakeTimeout != null) {
                this.config.set(DtlsConfig.DTLS_AUTO_HANDSHAKE_TIMEOUT, Long.valueOf(TimeUtils.toNanos(toVisit.autoHandshakeTimeout)), TimeUnit.NANOSECONDS);
            }
            this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_ANTI_REPLAY_FILTER, (Object)toVisit.useAntiReplayFilter);
            if (toVisit.useExtendedAntiReplayFilterWindow) {
                if (toVisit.antiReplayFilterWindowExtension == null) {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER, (Object)-1);
                } else {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER, (Object)Math.max(0, toVisit.antiReplayFilterWindowExtension));
                }
            } else {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER, (Object)0);
            }
        }
        catch (InternalInvalidDurationException e) {
            throw new ConfigException("dtls-params configuration error", e);
        }
    }

    @Override
    public void visit(DtlsMessageParams toVisit) throws ConfigException {
        if (toVisit.recordSizeLimit != null) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_RECORD_SIZE_LIMIT, (Object)toVisit.recordSizeLimit);
        }
        if (toVisit.maxFragmentLength != null) {
            switch (toVisit.maxFragmentLength) {
                case BYTES_512: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_FRAGMENT_LENGTH, (Object)MaxFragmentLengthExtension.Length.BYTES_512);
                    break;
                }
                case BYTES_1024: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_FRAGMENT_LENGTH, (Object)MaxFragmentLengthExtension.Length.BYTES_1024);
                    break;
                }
                case BYTES_2048: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_FRAGMENT_LENGTH, (Object)MaxFragmentLengthExtension.Length.BYTES_2048);
                    break;
                }
                case BYTES_4096: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_FRAGMENT_LENGTH, (Object)MaxFragmentLengthExtension.Length.BYTES_4096);
                    break;
                }
            }
        }
        if (toVisit.maxFragmentedHandshakeMsgLength != null) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH, (Object)toVisit.maxFragmentedHandshakeMsgLength);
        }
        if (toVisit.multiRecords != null) {
            switch (toVisit.multiRecords) {
                case NO: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_MULTI_RECORD_MESSAGES, (Object)false);
                    break;
                }
                case YES: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_MULTI_RECORD_MESSAGES, (Object)true);
                    break;
                }
            }
        }
        if (toVisit.multiHandshakeMsgRecords != null) {
            switch (toVisit.multiHandshakeMsgRecords) {
                case NO: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_MULTI_HANDSHAKE_MESSAGE_RECORDS, (Object)false);
                    break;
                }
                case YES: {
                    this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_MULTI_HANDSHAKE_MESSAGE_RECORDS, (Object)true);
                    break;
                }
            }
        }
        if (toVisit.mtu != null) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_TRANSMISSION_UNIT, (Object)toVisit.mtu);
        }
        if (toVisit.mtuLimit != null) {
            this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_TRANSMISSION_UNIT_LIMIT, (Object)toVisit.mtuLimit);
        }
    }

    @Override
    public void visit(DtlsRetransmissionParams toVisit) throws ConfigException {
        try {
            if (toVisit.initialTimeout != null) {
                this.config.set(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, Long.valueOf(TimeUtils.toNanos(toVisit.initialTimeout)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.maxTimeout != null) {
                this.config.set(DtlsConfig.DTLS_MAX_RETRANSMISSION_TIMEOUT, Long.valueOf(TimeUtils.toNanos(toVisit.maxTimeout)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.timeoutRandomFactor != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_RETRANSMISSION_INIT_RANDOM, (Object)toVisit.timeoutRandomFactor);
            }
            if (toVisit.timeoutScaleFactor != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT_SCALE, (Object)toVisit.timeoutScaleFactor);
            }
            if (toVisit.additionalEccTimeout != null) {
                this.config.set(DtlsConfig.DTLS_ADDITIONAL_ECC_TIMEOUT, Long.valueOf(TimeUtils.toNanos(toVisit.additionalEccTimeout)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.maxRetransmissions != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_MAX_RETRANSMISSIONS, (Object)toVisit.maxRetransmissions);
            }
            if (toVisit.backoffThreshold != null) {
                this.config.set((BasicDefinition)DtlsConfig.DTLS_RETRANSMISSION_BACKOFF, (Object)toVisit.backoffThreshold);
            }
            this.config.set((BasicDefinition)DtlsConfig.DTLS_USE_EARLY_STOP_RETRANSMISSION, (Object)toVisit.earlyStop);
        }
        catch (InternalInvalidDurationException e) {
            throw new ConfigException("dtls-retransmission-params configuration error", e);
        }
    }

    @Override
    public void visit(DatagramFilter toVisit) throws ConfigException {
        if (toVisit.macErrorThreshold <= 0) {
            throw new ConfigException("mac-error-filter configuration error: invalid threshold { " + toVisit.macErrorThreshold + " }");
        }
        this.config.set((BasicDefinition)DtlsConfig.DTLS_MAC_ERROR_FILTER_THRESHOLD, (Object)toVisit.macErrorThreshold);
        try {
            Long quitTime = TimeUtils.toNanos(toVisit.quitTime);
            if (quitTime <= 0L) {
                throw new ConfigException("mac-error-filter configuration error: invalid quit time { " + quitTime + " }");
            }
            this.config.set(DtlsConfig.DTLS_MAC_ERROR_FILTER_QUIET_TIME, quitTime, TimeUnit.NANOSECONDS);
        }
        catch (InternalInvalidDurationException e) {
            throw new ConfigException("mac-error-filter configuration error", e);
        }
    }

    @Override
    public void visit(SocketParams toVisit) {
        if (toVisit.receiveBuffer != null) {
            this.config.set((BasicDefinition)UdpConfig.UDP_RECEIVE_BUFFER_SIZE, (Object)toVisit.receiveBuffer);
            this.config.set((BasicDefinition)DtlsConfig.DTLS_RECEIVE_BUFFER_SIZE, (Object)toVisit.receiveBuffer);
        }
        if (toVisit.sendBuffer != null) {
            this.config.set((BasicDefinition)UdpConfig.UDP_SEND_BUFFER_SIZE, (Object)toVisit.sendBuffer);
            this.config.set((BasicDefinition)DtlsConfig.DTLS_SEND_BUFFER_SIZE, (Object)toVisit.sendBuffer);
        }
    }

    @Override
    public void visit(NotificationParams toVisit) throws ConfigException {
        try {
            if (toVisit.maxObserves != null) {
                if (toVisit.maxObserves > 0) {
                    this.config.set((BasicDefinition)CoapConfig.MAX_SERVER_OBSERVES, (Object)toVisit.maxObserves);
                } else if (toVisit.maxObserves < 0) {
                    this.config.set((BasicDefinition)CoapConfig.MAX_SERVER_OBSERVES, (Object)0);
                } else {
                    this.config.set((BasicDefinition)CoapConfig.MAX_SERVER_OBSERVES, (Object)-1);
                }
            }
            if (toVisit.checkIntervalTime != null) {
                this.config.set(CoapConfig.NOTIFICATION_CHECK_INTERVAL_TIME, Long.valueOf(TimeUtils.toNanos(toVisit.checkIntervalTime)), TimeUnit.NANOSECONDS);
            }
            if (toVisit.checkIntervalCount != null) {
                this.config.set((BasicDefinition)CoapConfig.NOTIFICATION_CHECK_INTERVAL_COUNT, (Object)toVisit.checkIntervalCount);
            }
            if (toVisit.reregistrationBackoff != null) {
                this.config.set(CoapConfig.NOTIFICATION_REREGISTRATION_BACKOFF, Long.valueOf(TimeUtils.toNanos(toVisit.reregistrationBackoff)), TimeUnit.NANOSECONDS);
            }
        }
        catch (InternalInvalidDurationException e) {
            throw new ConfigException("notification-params configuration error", e);
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }
}

