/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.config;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import nl.teslanet.mule.connectors.coap.api.MulticastReceiverConfig;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.UDPEndpoint;
import nl.teslanet.mule.connectors.coap.internal.config.EndpointConfigVisitor;
import nl.teslanet.mule.connectors.coap.internal.exceptions.EndpointConstructionException;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.UdpMulticastConnector;

public class UdpEndpointConfigVisitor
extends EndpointConfigVisitor {
    private static final String EXCEPTION_FORMAT = "CoAP Endpoint { %s } construction failed. %s: { %s }";
    private List<MulticastReceiverConfig> multicastReceivers = null;

    @Override
    public void visit(UDPEndpoint toVisit) {
        this.multicastReceivers = toVisit.multicastReceivers;
    }

    @Override
    public CoapEndpoint getEndpoint() throws EndpointConstructionException {
        UDPConnector connector = new UDPConnector(this.getLocalAddress(), this.getConfiguration());
        connector.setReuseAddress(this.isReuseAddress());
        if (this.multicastReceivers != null) {
            for (MulticastReceiverConfig receiver : this.multicastReceivers) {
                UdpMulticastConnector.Builder receiverBuilder = new UdpMulticastConnector.Builder();
                receiverBuilder.setConfiguration(this.getConfiguration());
                receiverBuilder.setMulticastReceiver(true);
                receiverBuilder.setLocalAddress(new InetSocketAddress(receiver.group, (int)receiver.bindToPort));
                try {
                    receiverBuilder.addMulticastGroup(InetAddress.getByName(receiver.group), NetworkInterface.getByName(receiver.networkInterface));
                    connector.addMulticastReceiver(receiverBuilder.build());
                }
                catch (SocketException | UnknownHostException e) {
                    throw new EndpointConstructionException(String.format(EXCEPTION_FORMAT, this.getEndpointName(), "Multicast receiver is invalid", receiver), e);
                }
            }
        }
        this.endpointBuilder.setConnector((Connector)connector);
        return this.endpointBuilder.build();
    }
}

