/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import nl.teslanet.mule.connectors.coap.api.CoapResponseCode;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapRequestAttributes;
import nl.teslanet.mule.connectors.coap.internal.attributes.CoapRequestAttributesImpl;
import nl.teslanet.mule.connectors.coap.internal.attributes.CoapRequestOptionsAttributesImpl;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidMessageTypeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidRequestCodeException;
import nl.teslanet.mule.connectors.coap.internal.options.MediaTypeMediator;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributeUtils;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AbstractResource
extends CoapResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResource.class);
    protected static final Marker ERROR_RESPONSE_MARKER = MarkerFactory.getMarker((String)"ERROR_RESPONSE");
    protected static final String NO_LISTENER_LOG_FORMAT = "NO LISTENER for request { {}, {} }";
    protected static final String CSV_REGEX = ",";
    protected boolean earlyAck = false;

    public AbstractResource(String name, boolean visible) {
        super(name, visible);
    }

    protected void handleRequest(SourceCallback<InputStream, CoapRequestAttributes> callback, CoapExchange exchange, CoapResponseCode defaultCoapResponseCode) {
        CoapRequestAttributesImpl requestAttributes;
        if (callback == null) {
            exchange.respond(CoAP.ResponseCode.NOT_IMPLEMENTED, "NO LISTENER");
            if (LOGGER.isWarnEnabled(ERROR_RESPONSE_MARKER)) {
                try {
                    LOGGER.warn(ERROR_RESPONSE_MARKER, NO_LISTENER_LOG_FORMAT, (Object)AttributeUtils.toRequestCodeAttribute(exchange.advanced().getCurrentRequest().getCode()), (Object)exchange.advanced().getCurrentRequest().getURI());
                }
                catch (InternalInvalidRequestCodeException e) {
                    LOGGER.warn(ERROR_RESPONSE_MARKER, NO_LISTENER_LOG_FORMAT, (Object)exchange.advanced().getCurrentRequest().getCode(), (Object)exchange.advanced().getCurrentRequest().getURI());
                }
            }
            return;
        }
        if (this.earlyAck) {
            exchange.accept();
        }
        try {
            requestAttributes = this.createRequestAttributes(exchange);
        }
        catch (Exception e1) {
            Response response = new Response(CoAP.ResponseCode.BAD_OPTION);
            response.setPayload(e1.getMessage());
            exchange.respond(response);
            return;
        }
        SourceCallbackContext requestcontext = callback.createContext();
        requestcontext.addVariable("defaultResponseCode", (Object)defaultCoapResponseCode);
        requestcontext.addVariable("coapExchange", (Object)exchange);
        byte[] requestPayload = exchange.getRequestPayload();
        callback.handle(Result.builder().output((Object)new ByteArrayInputStream(requestPayload)).length((long)requestPayload.length).attributes((Object)requestAttributes).mediaType(MediaTypeMediator.toMediaType(exchange.getRequestOptions().getContentFormat())).build(), requestcontext);
    }

    protected CoapRequestAttributesImpl createRequestAttributes(CoapExchange coapExchange) throws InternalInvalidOptionValueException, InternalInvalidMessageTypeException, InternalInvalidRequestCodeException {
        Exchange exchange = coapExchange.advanced();
        CoapRequestAttributesImpl attributes = new CoapRequestAttributesImpl();
        attributes.setRequestType(AttributeUtils.toMessageTypeAttribute(coapExchange.advanced().getRequest().getType()).name());
        attributes.setRequestCode(AttributeUtils.toRequestCodeAttribute(coapExchange.getRequestCode()).name());
        attributes.setLocalAddress(exchange.getEndpoint().getAddress().toString());
        attributes.setRemoteAddress(coapExchange.getSourceSocketAddress().toString());
        attributes.setRequestUri(exchange.getRequest().getURI());
        attributes.setRequestOptions(new CoapRequestOptionsAttributesImpl(coapExchange.getRequestOptions()));
        attributes.setRelation(exchange.getRelation() != null ? exchange.getRelation().getKeyToken().toString() : null);
        return attributes;
    }

    public void setGetCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getGetCallback() {
        return null;
    }

    public void setPostCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getPostCallback() {
        return null;
    }

    public void setPutCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getPutCallback() {
        return null;
    }

    public void setDeleteCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getDeleteCallback() {
        return null;
    }

    public void setFetchCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getFetchCallback() {
        return null;
    }

    public void setPatchCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getPatchCallback() {
        return null;
    }

    public void setIpatchCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getIpatchCallback() {
        return null;
    }
}

