/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.server;

import java.io.InputStream;
import nl.teslanet.mule.connectors.coap.api.CoapResponseCode;
import nl.teslanet.mule.connectors.coap.api.ConfigurableResource;
import nl.teslanet.mule.connectors.coap.api.NewSubResource;
import nl.teslanet.mule.connectors.coap.api.ResourceConfig;
import nl.teslanet.mule.connectors.coap.api.ResourceParams;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapRequestAttributes;
import nl.teslanet.mule.connectors.coap.internal.server.AbstractResource;
import nl.teslanet.mule.connectors.coap.internal.server.RequestCodeFlags;
import nl.teslanet.mule.connectors.coap.internal.server.ResourceRegistry;
import nl.teslanet.mule.connectors.coap.internal.server.VirtualResource;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public class ServedResource
extends AbstractResource {
    private SourceCallback<InputStream, CoapRequestAttributes> getCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> postCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> putCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> deleteCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> fetchCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> patchCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> ipatchCallback = null;
    private RequestCodeFlags requestCodeFlags = new RequestCodeFlags();

    public ServedResource(ResourceConfig resource) {
        super(resource.getResourceName(), true);
        this.configure(resource);
        if (resource.getSubResources() != null) {
            for (ResourceConfig childResourceConfig : resource.getSubResources()) {
                ServedResource child = new ServedResource(childResourceConfig);
                this.add(child);
            }
        }
        this.configureVirtualSubResource(resource);
    }

    public ServedResource(ResourceParams resource) {
        super(ResourceRegistry.getUriResourceName(resource.getResourcePath()), true);
        this.configure(resource);
        this.configureVirtualSubResource(resource);
    }

    private void configureVirtualSubResource(ConfigurableResource resource) {
        NewSubResource newResource = resource.getNewSubResource();
        if (newResource != null && newResource.isPut()) {
            VirtualResource child = new VirtualResource(newResource.isEarlyAck());
            this.add(child);
        }
    }

    private void configure(ConfigurableResource resource) {
        this.requestCodeFlags.setGet(resource.isGet());
        this.requestCodeFlags.setPost(resource.isPost());
        this.requestCodeFlags.setPut(resource.isPut());
        this.requestCodeFlags.setDelete(resource.isDelete());
        this.requestCodeFlags.setFetch(resource.isFetch());
        this.requestCodeFlags.setPatch(resource.isPatch());
        this.requestCodeFlags.setIpatch(resource.isIpatch());
        this.earlyAck = resource.isEarlyAck();
        if (resource.isObservable()) {
            this.setObservable(true);
            this.getAttributes().setObservable();
        } else {
            this.setObservable(false);
        }
        if (resource.getCoreInfo() != null) {
            if (resource.getCoreInfo().getTitle() != null) {
                this.getAttributes().setTitle(resource.getCoreInfo().getTitle());
            }
            if (resource.getCoreInfo().getRt() != null) {
                for (String rt : StringUtils.deleteWhitespace((String)resource.getCoreInfo().getRt()).split(",")) {
                    this.getAttributes().addResourceType(rt);
                }
            }
            if (resource.getCoreInfo().getIfdesc() != null) {
                for (String ifdesc : StringUtils.deleteWhitespace((String)resource.getCoreInfo().getIfdesc()).split(",")) {
                    this.getAttributes().addInterfaceDescription(ifdesc);
                }
            }
            if (resource.getCoreInfo().getCt() != null) {
                for (String ct : StringUtils.deleteWhitespace((String)resource.getCoreInfo().getCt()).split(",")) {
                    this.getAttributes().addContentType(Integer.parseInt(ct));
                }
            }
            if (resource.getCoreInfo().getSz() != null) {
                this.getAttributes().setMaximumSizeEstimate(resource.getCoreInfo().getSz());
            }
        }
    }

    public void handleGET(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotGet()) {
            super.handleGET(exchange);
        } else {
            this.handleRequest(this.getCallback, exchange, CoapResponseCode.CONTENT);
        }
    }

    public void handlePUT(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotPut()) {
            super.handlePUT(exchange);
        } else {
            this.handleRequest(this.putCallback, exchange, CoapResponseCode.CHANGED);
        }
    }

    public void handlePOST(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotPost()) {
            super.handlePOST(exchange);
        } else {
            this.handleRequest(this.postCallback, exchange, CoapResponseCode.CHANGED);
        }
    }

    public void handleDELETE(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotDelete()) {
            super.handleDELETE(exchange);
        } else {
            this.handleRequest(this.deleteCallback, exchange, CoapResponseCode.DELETED);
        }
    }

    public void handleFETCH(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotFetch()) {
            super.handleFETCH(exchange);
        } else {
            this.handleRequest(this.fetchCallback, exchange, CoapResponseCode.CONTENT);
        }
    }

    public void handlePATCH(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotPatch()) {
            super.handlePATCH(exchange);
        } else {
            this.handleRequest(this.patchCallback, exchange, CoapResponseCode.CHANGED);
        }
    }

    public void handleIPATCH(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotIpatch()) {
            super.handleIPATCH(exchange);
        } else {
            this.handleRequest(this.ipatchCallback, exchange, CoapResponseCode.CHANGED);
        }
    }

    @Override
    public void setGetCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.getCallback = sourceCallback;
    }

    @Override
    public SourceCallback<InputStream, CoapRequestAttributes> getGetCallback() {
        return this.getCallback;
    }

    @Override
    public void setPostCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.postCallback = sourceCallback;
    }

    @Override
    public SourceCallback<InputStream, CoapRequestAttributes> getPostCallback() {
        return this.postCallback;
    }

    @Override
    public void setPutCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.putCallback = sourceCallback;
    }

    @Override
    public SourceCallback<InputStream, CoapRequestAttributes> getPutCallback() {
        return this.putCallback;
    }

    @Override
    public void setDeleteCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.deleteCallback = sourceCallback;
    }

    @Override
    public SourceCallback<InputStream, CoapRequestAttributes> getDeleteCallback() {
        return this.deleteCallback;
    }

    @Override
    public void setFetchCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.fetchCallback = sourceCallback;
    }

    @Override
    public SourceCallback<InputStream, CoapRequestAttributes> getFetchCallback() {
        return this.fetchCallback;
    }

    @Override
    public void setPatchCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.patchCallback = sourceCallback;
    }

    @Override
    public SourceCallback<InputStream, CoapRequestAttributes> getPatchCallback() {
        return this.patchCallback;
    }

    @Override
    public void setIpatchCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.ipatchCallback = sourceCallback;
    }

    @Override
    public SourceCallback<InputStream, CoapRequestAttributes> getIpatchCallback() {
        return this.ipatchCallback;
    }
}

