/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import nl.teslanet.mule.connectors.coap.api.EndpointInfo;
import nl.teslanet.mule.connectors.coap.api.ResourceConfig;
import nl.teslanet.mule.connectors.coap.api.ServerInfo;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.AbstractEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.AdditionalEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.UDPEndpoint;
import nl.teslanet.mule.connectors.coap.internal.endpoint.OperationalEndpoint;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResourceRegistryException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUriPatternException;
import nl.teslanet.mule.connectors.coap.internal.server.Listener;
import nl.teslanet.mule.connectors.coap.internal.server.OperationalListener;
import nl.teslanet.mule.connectors.coap.internal.server.ResourceRegistry;
import nl.teslanet.mule.connectors.coap.internal.server.ServedResourceMessageDeliverer;
import nl.teslanet.mule.connectors.coap.internal.server.ServerOperations;
import nl.teslanet.mule.connectors.coap.internal.utils.TimeUtils;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.elements.config.Configuration;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.NoImplicit;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.mule.runtime.extension.api.annotation.Configuration(name="server")
@NoImplicit
@Sources(value={Listener.class})
@Operations(value={ServerOperations.class})
public class Server
implements Initialisable,
Disposable,
Startable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Server.class.getCanonicalName());
    public static final String VARNAME_COAP_EXCHANGE = "coapExchange";
    public static final String VARNAME_DEFAULT_RESPONSE_CODE = "defaultResponseCode";
    @RefName
    private String serverName;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private SchedulerConfig schedulerConfig;
    private Scheduler ioScheduler = null;
    private Scheduler cpuLightScheduler = null;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="Main endpoint the server uses.")
    @Placement(order=1, tab="Endpoint")
    private nl.teslanet.mule.connectors.coap.api.config.endpoint.Endpoint endpoint;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="Additional endpoints the server uses.")
    @Placement(order=4, tab="Advanced")
    private List<AdditionalEndpoint> additionalEndpoints;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The root resources of the server.")
    private List<ResourceConfig> resources;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Notify observing clients of server shutdown. \nWhen true observing clients are notified by Not-Found notifications. \nDefault value is 100 ms.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Notify observing clients on shutdown")
    @Placement(order=1, tab="Advanced")
    private boolean notifyOnShutdown = true;
    @Parameter
    @Optional(defaultValue="250ms")
    @Summary(value="The linger duration on shutdown of the server, \ngiving notifications time to complete. \nDefault value is 250 ms.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Placement(order=2, tab="Advanced")
    private String lingerOnShutdown = "250ms";
    private CoapServer coapServer = null;
    private ResourceRegistry registry = null;
    private long lingerOnShutdownMillis = 250L;

    public void initialise() throws InitialisationException {
        Configuration config = Configuration.createStandardWithoutFile();
        this.coapServer = new CoapServer(config, new int[0]);
        try {
            this.registry = new ResourceRegistry(this.coapServer.getRoot());
        }
        catch (InternalResourceRegistryException e1) {
            throw new InitialisationException((Throwable)e1, (Initialisable)this);
        }
        this.coapServer.setMessageDeliverer((MessageDeliverer)new ServedResourceMessageDeliverer(this.registry, config));
        ArrayList<AbstractEndpoint> configuredEndpoints = new ArrayList<AbstractEndpoint>();
        if (this.endpoint != null) {
            if (this.endpoint.getEndpointConfig() == null || this.endpoint.getEndpointConfig().getEndpoint() == null) {
                throw new InitialisationException((Throwable)new IllegalArgumentException("Unexpected null value in main server endpoint."), (Initialisable)this);
            }
            configuredEndpoints.add(this.endpoint.getEndpointConfig().getEndpoint());
        } else if (this.additionalEndpoints.isEmpty()) {
            configuredEndpoints.add(new UDPEndpoint(this.toString() + " default", 5683));
            LOGGER.info("{} is using default udp endpoint.", (Object)this);
        }
        for (AdditionalEndpoint additionalEndpoint : this.additionalEndpoints) {
            if (additionalEndpoint.getEndpoint() == null) {
                throw new InitialisationException((Throwable)new IllegalArgumentException("Unexpected null value in additional server endpoint."), (Initialisable)this);
            }
            configuredEndpoints.add(additionalEndpoint.getEndpoint());
        }
        int endpointNr = 0;
        for (AbstractEndpoint configuredEndpoint : configuredEndpoints) {
            if (configuredEndpoint.configName == null) {
                configuredEndpoint.configName = this.toString() + " endpont-" + endpointNr++;
            }
            try {
                OperationalEndpoint operationalEndpoint = OperationalEndpoint.getOrCreate(this, configuredEndpoint);
                this.coapServer.addEndpoint((Endpoint)operationalEndpoint.getCoapEndpoint());
                LOGGER.info("{} connected to {}", (Object)this, (Object)operationalEndpoint);
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        LOGGER.info("{} initalised.", (Object)this);
    }

    public void dispose() {
        this.coapServer.destroy();
        this.coapServer = null;
        OperationalEndpoint.disposeAll(this);
        LOGGER.info("{} disposed.", (Object)this);
    }

    public void start() throws MuleException {
        try {
            this.lingerOnShutdownMillis = TimeUtils.toNanos(this.lingerOnShutdown) / 1000000L;
            if (this.resources != null) {
                for (ResourceConfig resourceConfig : this.resources) {
                    this.registry.add(null, resourceConfig);
                }
            }
            SchedulerConfig config = this.schedulerConfig.withPrefix(this.getServerName());
            this.ioScheduler = this.schedulerService.ioScheduler(config);
            this.cpuLightScheduler = this.schedulerService.cpuLightScheduler(config);
            this.coapServer.setExecutors((ScheduledExecutorService)this.ioScheduler, (ScheduledExecutorService)this.cpuLightScheduler, true);
            this.coapServer.start();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e, (Startable)this);
        }
        LOGGER.info("{} started.", (Object)this);
    }

    public void stop() throws MuleException {
        if (this.notifyOnShutdown) {
            this.registry.removeAll();
        }
        try {
            Thread.sleep(this.lingerOnShutdownMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.coapServer.stop();
            if (!this.notifyOnShutdown) {
                this.registry.removeAll();
            }
            this.ioScheduler = null;
            this.cpuLightScheduler = null;
            LOGGER.info("{} stopped", (Object)this);
        }
    }

    void addListener(OperationalListener operationalListener) throws InternalUriPatternException {
        this.registry.add(operationalListener);
    }

    void removeListener(OperationalListener listener) {
        this.registry.remove(listener);
    }

    public String getServerName() {
        return this.serverName;
    }

    public ResourceRegistry getRegistry() {
        return this.registry;
    }

    public List<ResourceConfig> getResources() {
        return this.resources;
    }

    public void setResources(List<ResourceConfig> resources) {
        this.resources = resources;
    }

    public List<AdditionalEndpoint> getAdditionalEndpoints() {
        return this.additionalEndpoints;
    }

    public void setAdditionalEndpoints(List<AdditionalEndpoint> endpoints) {
        this.additionalEndpoints = endpoints;
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public SchedulerConfig getSchedulerConfig() {
        return this.schedulerConfig;
    }

    public ServerInfo getInfo() {
        CopyOnWriteArrayList<EndpointInfo> endpoints = new CopyOnWriteArrayList<EndpointInfo>();
        for (Endpoint endpoint : this.coapServer.getEndpoints()) {
            URI uri = endpoint.getUri();
            endpoints.add(new EndpointInfo(uri.getScheme(), uri.getHost(), uri.getPort()));
        }
        return new ServerInfo(this.serverName, endpoints);
    }

    public String toString() {
        return "CoAP Server { " + this.getServerName() + " }";
    }
}

