/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.utils;

import java.util.Optional;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidDurationException;
import org.apache.commons.lang3.StringUtils;

public class TimeUtils {
    private static final String GROUP_BEGIN = "^(?:";
    private static final String DAY_PART = "(?:([0-9]{1,5})(d))?";
    private static final String HOUR_PART = "(?:([0-9]{1,5})(h))?";
    private static final String MINUTE_PART = "(?:([0-9]{1,5})(m))?";
    private static final String SECOND_PART = "(?:([0-9]{1,5})(s))?";
    private static final String MILLISECOND_PART = "(?:([0-9]{1,5})(ms))?";
    private static final String MICROSECOND_PART = "(?:([0-9]{1,5})(us))?";
    private static final String NANOSECOND_PART = "(?:([0-9]{1,5})(ns))?";
    private static final String GROUP_END = ")$";
    private static final String OR = "|";
    private static final String SECOND_SINGLE = "^(?:([0-9]{1,9})(s))$";
    private static final String MILLISECOND_SINGLE = "^(?:([0-9]{1,12})(ms))$";
    private static final String MICROSECOND_SINGLE = "^(?:([0-9]{1,15})(us))$";
    private static final String NANOSECOND_SINGLE = "^(?:([0-9]{1,18})(ns))$";
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(?:(?:([0-9]{1,5})(d))?(?:([0-9]{1,5})(h))?(?:([0-9]{1,5})(m))?(?:([0-9]{1,5})(s))?(?:([0-9]{1,5})(ms))?(?:([0-9]{1,5})(us))?(?:([0-9]{1,5})(ns))?)$|^(?:([0-9]{1,9})(s))$|^(?:([0-9]{1,12})(ms))$|^(?:([0-9]{1,15})(us))$|^(?:([0-9]{1,18})(ns))$");

    private TimeUtils() {
    }

    public static long toNanos(String expression) throws InternalInvalidDurationException {
        long result = 0L;
        String stripped = StringUtils.deleteWhitespace((String)expression);
        if (StringUtils.isEmpty((CharSequence)stripped)) {
            throw new InternalInvalidDurationException("Empty duration is not allowed.");
        }
        try (Scanner scanner = new Scanner(stripped);){
            scanner.findInLine(DURATION_PATTERN);
            MatchResult groups = scanner.match();
            int count = groups.groupCount();
            if (count < 2 || count % 2 != 0) {
                throw new InternalInvalidDurationException("Duration should contain value and unit.");
            }
            result = TimeUtils.calculateNanos(groups);
        }
        return result;
    }

    private static long calculateNanos(MatchResult groups) {
        long result = 0L;
        for (int i = 1; i <= groups.groupCount(); i += 2) {
            Optional<NanosPart> optionalPart;
            long value = 0L;
            String valueString = groups.group(i);
            String unit = groups.group(i + 1);
            if (!StringUtils.isEmpty((CharSequence)valueString)) {
                value = Long.valueOf(valueString);
            }
            if (!(optionalPart = TimeUtils.findNanosPart(unit)).isPresent()) continue;
            result = Math.addExact(result, Math.multiplyExact(value, optionalPart.get().getNanos()));
        }
        return result;
    }

    public static String nanosToString(long nanos) throws InternalInvalidDurationException {
        if (nanos < 0L) {
            throw new InternalInvalidDurationException("Negative value is not allowed.");
        }
        StringBuilder builder = new StringBuilder();
        if (nanos == 0L) {
            builder.append(0L);
            builder.append("ms");
        } else {
            long rest = nanos;
            boolean hasPrevious = false;
            for (NanosPart part : NanosPart.values()) {
                long value = rest / part.getNanos();
                if (value <= 0L) continue;
                if (hasPrevious) {
                    builder.append(" ");
                }
                hasPrevious = true;
                rest -= value * part.getNanos();
                builder.append(value);
                builder.append(part.getUnit());
            }
        }
        return builder.toString();
    }

    private static Optional<NanosPart> findNanosPart(String partUnit) {
        for (NanosPart part : NanosPart.values()) {
            if (!part.getUnit().equals(partUnit)) continue;
            return Optional.of(part);
        }
        return Optional.empty();
    }

    public static enum NanosPart {
        DAY("d", 86400000000000L),
        HOUR("h", 3600000000000L),
        MINUTE("m", 60000000000L),
        SECOND("s", 1000000000L),
        MILLISECOND("ms", 1000000L),
        MICROSECOND("us", 1000L),
        NANO_SECOND("ns", 1L);

        private final String unit;
        private final long nanos;

        private NanosPart(String unit, long nanos) {
            this.unit = unit;
            this.nanos = nanos;
        }

        public String getUnit() {
            return this.unit;
        }

        public long getNanos() {
            return this.nanos;
        }
    }
}

