/*-
 * #%L
 * Mule CoAP Connector
 * %%
 * Copyright (C) 2019 - 2025 (teslanet.nl) Rogier Cobben
 * 
 * Contributors:
 *     (teslanet.nl) Rogier Cobben - initial creation
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package nl.teslanet.mule.connectors.coap.api;


import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;


/**
 * The request parameters for stopping an CoAP observer.
 *
 */
public class ObserverRemoveParams extends AbstractResourceRequestParams
{
    /**
     * When true a cancel message is sent. Otherwise a passive cancel is executed.
     * When DEFAULT the client default is used.
     */
    @Parameter
    @Optional( defaultValue= "DEFAULT" )
    @Expression( ExpressionSupport.SUPPORTED )
    @Summary(
        "When true a cancel message is sent. \nOtherwise a passive cancel is executed.\n When DEFAULT the client default is used"
    )
    @Placement( order= 71 )
    private ObserveCancel observeCancel= ObserveCancel.DEFAULT;

    /**
     * @return the observeCancel
     */
    public ObserveCancel getObserveCancel()
    {
        return observeCancel;
    }

    /**
     * @param observeCancel the observeCancel to set
     */
    public void setObserveCancel( ObserveCancel observeCancel )
    {
        this.observeCancel= observeCancel;
    }
}
