/*
 * Decompiled with CFR 0.152.
 */
package hla.rti1516e;

import hla.rti1516e.LogicalTimeFactory;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;

public class LogicalTimeFactoryFactory {
    public static LogicalTimeFactory getLogicalTimeFactory(String name) {
        if (name.equals("")) {
            name = "HLAfloat64Time";
        }
        ServiceLoader<LogicalTimeFactory> loader = ServiceLoader.load(LogicalTimeFactory.class);
        for (LogicalTimeFactory logicalTimeFactory : loader) {
            if (!logicalTimeFactory.getName().equals(name)) continue;
            return logicalTimeFactory;
        }
        return null;
    }

    public static <T extends LogicalTimeFactory> T getLogicalTimeFactory(Class<T> logicalTimeFactoryClass) {
        ServiceLoader<LogicalTimeFactory> loader = ServiceLoader.load(LogicalTimeFactory.class);
        for (LogicalTimeFactory logicalTimeFactory : loader) {
            if (!logicalTimeFactoryClass.isInstance(logicalTimeFactory)) continue;
            return (T)((LogicalTimeFactory)logicalTimeFactoryClass.cast(logicalTimeFactory));
        }
        return null;
    }

    public static Set<LogicalTimeFactory> getAvailableLogicalTimeFactories() {
        HashSet<LogicalTimeFactory> factories = new HashSet<LogicalTimeFactory>();
        ServiceLoader<LogicalTimeFactory> loader = ServiceLoader.load(LogicalTimeFactory.class);
        for (LogicalTimeFactory logicalTimeFactory : loader) {
            factories.add(logicalTimeFactory);
        }
        return factories;
    }
}

