/*
 * Decompiled with CFR 0.152.
 */
package hla.rti1516e;

import hla.rti1516e.RtiFactory;
import hla.rti1516e.exceptions.RTIinternalError;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RtiFactoryFactory {
    public static RtiFactory getRtiFactory(String name) throws RTIinternalError {
        ServiceLoader<RtiFactory> loader = ServiceLoader.load(RtiFactory.class);
        Iterator<RtiFactory> it = loader.iterator();
        while (it.hasNext()) {
            try {
                RtiFactory rtiFactory = it.next();
                if (!rtiFactory.rtiName().equals(name)) continue;
                return rtiFactory;
            }
            catch (UnsatisfiedLinkError | ServiceConfigurationError ex) {
                Logger.getLogger(RtiFactoryFactory.class.getName()).log(Level.WARNING, ex.getMessage());
            }
        }
        throw new RTIinternalError("Cannot find factory matching " + name);
    }

    public static RtiFactory getRtiFactory() throws RTIinternalError {
        ServiceLoader<RtiFactory> loader = ServiceLoader.load(RtiFactory.class);
        Iterator<RtiFactory> it = loader.iterator();
        while (it.hasNext()) {
            try {
                return it.next();
            }
            catch (UnsatisfiedLinkError | ServiceConfigurationError ex) {
                Logger.getLogger(RtiFactoryFactory.class.getName()).log(Level.WARNING, ex.getMessage());
            }
        }
        throw new RTIinternalError("Cannot find factory");
    }

    public static Set<RtiFactory> getAvailableRtiFactories() {
        HashSet<RtiFactory> factories = new HashSet<RtiFactory>();
        ServiceLoader<RtiFactory> loader = ServiceLoader.load(RtiFactory.class);
        Iterator<RtiFactory> it = loader.iterator();
        while (it.hasNext()) {
            try {
                factories.add(it.next());
            }
            catch (UnsatisfiedLinkError | ServiceConfigurationError ex) {
                Logger.getLogger(RtiFactoryFactory.class.getName()).log(Level.WARNING, ex.getMessage());
            }
        }
        return factories;
    }
}

