/*
 * Decompiled with CFR 0.152.
 */
package hla.rti1516e.encoding;

public class ByteWrapper {
    private static final byte[] ZERO_LENGTH_BUFFER = new byte[0];
    private int _offset;
    private int _pos;
    private int _limit;
    private byte[] _buffer;

    public ByteWrapper() {
        this(ZERO_LENGTH_BUFFER);
    }

    public ByteWrapper(int length) {
        this(new byte[length]);
    }

    public ByteWrapper(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public ByteWrapper(byte[] buffer, int offset) {
        this(buffer, offset, buffer.length - offset);
    }

    public ByteWrapper(byte[] buffer, int offset, int length) {
        this.setBuffer(buffer, offset, length);
    }

    public void reassign(byte[] buffer, int offset, int length) {
        this.setBuffer(buffer, offset, length);
    }

    private void setBuffer(byte[] buffer, int offset, int length) {
        this.checkBounds(buffer, offset, length);
        this._buffer = buffer;
        this._offset = offset;
        this._limit = this._offset + length;
        this._pos = this._offset;
    }

    private void checkBounds(byte[] buffer, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative offset: " + offset);
        }
        if (length < 0 || offset + length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("Offset + length (" + offset + " + " + length + ") past end of buffer: " + buffer.length);
        }
    }

    public void reset() {
        this._pos = this._offset;
    }

    public void verify(int length) {
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException(length);
        }
        if (this._pos + length > this._limit) {
            throw new ArrayIndexOutOfBoundsException(this._pos + length);
        }
    }

    public final int getInt() {
        this.verify(4);
        int pos = this._pos;
        byte[] buffer = this._buffer;
        int value = ((buffer[pos] & 0xFF) << 24) + ((buffer[pos + 1] & 0xFF) << 16) + ((buffer[pos + 2] & 0xFF) << 8) + (buffer[pos + 3] & 0xFF);
        this._pos += 4;
        return value;
    }

    public final int get() {
        this.verify(1);
        return this._buffer[this._pos++] & 0xFF;
    }

    public final void get(byte[] dest) {
        this.verify(dest.length);
        System.arraycopy(this._buffer, this._pos, dest, 0, dest.length);
        this._pos += dest.length;
    }

    public void putInt(int value) {
        this.verify(4);
        this.put(value >>> 24 & 0xFF);
        this.put(value >>> 16 & 0xFF);
        this.put(value >>> 8 & 0xFF);
        this.put(value >>> 0 & 0xFF);
    }

    public void put(int b) {
        this.verify(1);
        this._buffer[this._pos++] = (byte)b;
    }

    public void put(byte[] src) {
        this.verify(src.length);
        System.arraycopy(src, 0, this._buffer, this._pos, src.length);
        this._pos += src.length;
    }

    public void put(byte[] src, int offset, int count) {
        this.verify(count);
        System.arraycopy(src, offset, this._buffer, this._pos, count);
        this._pos += count;
    }

    public final byte[] array() {
        return this._buffer;
    }

    public final int getPos() {
        return this._pos;
    }

    public int remaining() {
        return this._limit - this._pos;
    }

    public final void advance(int n) {
        this.verify(n);
        this._pos += n;
    }

    public void align(int alignment) {
        while ((this._pos - this._offset) % alignment != 0) {
            this.advance(1);
        }
    }

    public ByteWrapper slice() {
        return new ByteWrapper(this._buffer, this._pos);
    }

    public ByteWrapper slice(int length) {
        this.verify(length);
        return new ByteWrapper(this._buffer, this._pos, length);
    }

    public String toString() {
        return "ByteWrapper{_offset=" + this._offset + ", _pos=" + this._pos + ", _limit=" + this._limit + ", _buffer=" + String.valueOf(this._buffer) + "}";
    }
}

