/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.omt.helpers;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.tno.omt.ArrayDataTypesType;
import nl.tno.omt.Attribute;
import nl.tno.omt.BasicDataRepresentationsType;
import nl.tno.omt.DataTypesType;
import nl.tno.omt.EnumeratedDataTypesType;
import nl.tno.omt.FixedRecordDataTypesType;
import nl.tno.omt.InteractionClass;
import nl.tno.omt.ObjectClass;
import nl.tno.omt.ObjectFactory;
import nl.tno.omt.ObjectModelType;
import nl.tno.omt.Parameter;
import nl.tno.omt.SimpleDataTypesType;
import nl.tno.omt.TransportationsType;
import nl.tno.omt.VariantRecordDataTypesType;

public class OmtFunctions {
    private static JAXBContext jaxbContext = null;
    private static final ObjectFactory objectFactory = new ObjectFactory();

    private static synchronized JAXBContext getContext() throws IOException {
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectModelType.class});
            }
            catch (JAXBException ex) {
                throw new IOException(ex);
            }
        }
        return jaxbContext;
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException, IOException {
        return OmtFunctions.getContext().createUnmarshaller();
    }

    private static Marshaller createMarshaller(boolean formatted) throws JAXBException, IOException {
        Marshaller jaxbMarshaller = OmtFunctions.getContext().createMarshaller();
        if (formatted) {
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        return jaxbMarshaller;
    }

    private static ObjectModelType castObject(Object object) {
        JAXBElement element = (JAXBElement)object;
        return (ObjectModelType)element.getValue();
    }

    public static ObjectModelType readOmt(URL module) throws IOException {
        return OmtFunctions.readOmt(module.openStream());
    }

    public static ObjectModelType readOmt(InputStream input) throws IOException {
        ObjectModelType objectModelType;
        block8: {
            InputStream inputStream = input;
            try {
                objectModelType = OmtFunctions.castObject(OmtFunctions.createUnmarshaller().unmarshal(input));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JAXBException ex) {
                    throw new IOException(ex);
                }
            }
            inputStream.close();
        }
        return objectModelType;
    }

    public static ObjectModelType readOmt(Reader input) throws IOException {
        ObjectModelType objectModelType;
        block8: {
            Reader reader = input;
            try {
                objectModelType = OmtFunctions.castObject(OmtFunctions.createUnmarshaller().unmarshal(input));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JAXBException ex) {
                    throw new IOException(ex);
                }
            }
            reader.close();
        }
        return objectModelType;
    }

    public static Writer writeOmt(ObjectModelType omt, Writer output, boolean formatted) throws IOException {
        try {
            OmtFunctions.createMarshaller(formatted).marshal(objectFactory.createObjectModel(omt), output);
            return output;
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    public static Writer writeOmt(ObjectModelType omt, Writer output) throws IOException {
        return OmtFunctions.writeOmt(omt, output, false);
    }

    public static File writeOmt(ObjectModelType omt, File output, boolean formatted) throws IOException {
        try {
            OmtFunctions.createMarshaller(formatted).marshal(objectFactory.createObjectModel(omt), output);
            return output;
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    public static File writeOmt(ObjectModelType omt, File output) throws IOException {
        return OmtFunctions.writeOmt(omt, output, false);
    }

    public static OutputStream writeOmt(ObjectModelType omt, OutputStream output, boolean formatted) throws IOException {
        try {
            OmtFunctions.createMarshaller(formatted).marshal(objectFactory.createObjectModel(omt), output);
            return output;
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    public static OutputStream writeOmt(ObjectModelType omt, OutputStream output) throws IOException {
        return OmtFunctions.writeOmt(omt, output, false);
    }

    public static boolean isScaffoldingClass(ObjectClass oc) {
        return (oc.getAttribute() == null || oc.getAttribute().isEmpty()) && oc.getSemantics() == null && oc.getSharing() == null;
    }

    public static boolean isScaffoldingClass(InteractionClass ic) {
        return (ic.getParameter() == null || ic.getParameter().isEmpty()) && ic.getSemantics() == null && ic.getSharing() == null;
    }

    public static ObjectModelType getObjectClassModule(ObjectModelType[] modules, String fqName) {
        return OmtFunctions.getObjectClassModule(modules, fqName, true);
    }

    public static ObjectModelType getObjectClassModule(ObjectModelType[] modules, String fqName, boolean nullOnScaffolding) {
        for (ObjectModelType module : modules) {
            if (OmtFunctions.getObjectClass(module, fqName, nullOnScaffolding) == null) continue;
            return module;
        }
        return null;
    }

    public static ObjectClass getObjectClass(ObjectModelType[] modules, String fqName) {
        return OmtFunctions.getObjectClass(modules, fqName, true);
    }

    public static ObjectClass getObjectClass(ObjectModelType[] modules, String fqName, boolean nullOnScaffolding) {
        for (ObjectModelType module : modules) {
            ObjectClass oc = OmtFunctions.getObjectClass(module, fqName, nullOnScaffolding);
            if (oc == null) continue;
            return oc;
        }
        return null;
    }

    private static ObjectClass selectObjectClass(List<ObjectClass> list, String name) {
        for (ObjectClass oc : list) {
            if (!oc.getName().getValue().equals(name)) continue;
            return oc;
        }
        return null;
    }

    public static ObjectClass getObjectClass(ObjectModelType module, String fqName) {
        return OmtFunctions.getObjectClass(module, fqName, true);
    }

    public static ObjectClass getObjectClass(ObjectModelType module, String fqName, boolean nullOnScaffolding) {
        if (module.getObjects() == null) {
            return null;
        }
        String[] v = fqName.split("\\.");
        if (v.length == 0) {
            return null;
        }
        ObjectClass oc = module.getObjects().getObjectClass();
        if (!oc.getName().getValue().equals(v[0])) {
            return null;
        }
        for (int i = 1; i < v.length; ++i) {
            if ((oc = OmtFunctions.selectObjectClass(oc.getObjectClass(), v[i])) != null) continue;
            return null;
        }
        return nullOnScaffolding ? (OmtFunctions.isScaffoldingClass(oc) ? null : oc) : oc;
    }

    public static Set<Attribute> getObjectClassAttributes(ObjectModelType[] modules, String fqName) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        String name = null;
        for (String part : fqName.split("\\.")) {
            ObjectClass oc = OmtFunctions.getObjectClass(modules, name = name == null ? part : name + "." + part);
            if (oc == null) {
                return null;
            }
            attributes.addAll(oc.getAttribute());
        }
        return attributes;
    }

    public static ObjectModelType getInteractionClassModule(ObjectModelType[] modules, String fqName) {
        return OmtFunctions.getInteractionClassModule(modules, fqName, true);
    }

    public static ObjectModelType getInteractionClassModule(ObjectModelType[] modules, String fqName, boolean nullOnScaffolding) {
        for (ObjectModelType module : modules) {
            if (OmtFunctions.getInteractionClass(module, fqName, nullOnScaffolding) == null) continue;
            return module;
        }
        return null;
    }

    public static InteractionClass getInteractionClass(ObjectModelType[] modules, String fqName) {
        return OmtFunctions.getInteractionClass(modules, fqName, true);
    }

    public static InteractionClass getInteractionClass(ObjectModelType[] modules, String fqName, boolean nullOnScaffolding) {
        for (ObjectModelType module : modules) {
            InteractionClass ic = OmtFunctions.getInteractionClass(module, fqName, nullOnScaffolding);
            if (ic == null) continue;
            return ic;
        }
        return null;
    }

    private static InteractionClass selectInteractionClass(List<InteractionClass> list, String name) {
        for (InteractionClass ic : list) {
            if (!ic.getName().getValue().equals(name)) continue;
            return ic;
        }
        return null;
    }

    public static InteractionClass getInteractionClass(ObjectModelType module, String fqName) {
        return OmtFunctions.getInteractionClass(module, fqName, true);
    }

    public static InteractionClass getInteractionClass(ObjectModelType module, String fqName, boolean nullOnScaffolding) {
        if (module.getInteractions() == null) {
            return null;
        }
        String[] v = fqName.split("\\.");
        if (v.length == 0) {
            return null;
        }
        InteractionClass ic = module.getInteractions().getInteractionClass();
        if (!ic.getName().getValue().equals(v[0])) {
            return null;
        }
        for (int i = 1; i < v.length; ++i) {
            if ((ic = OmtFunctions.selectInteractionClass(ic.getInteractionClass(), v[i])) != null) continue;
            return null;
        }
        return nullOnScaffolding ? (OmtFunctions.isScaffoldingClass(ic) ? null : ic) : ic;
    }

    public static Set<Parameter> getInteractionClassParameters(ObjectModelType[] modules, String fqName) {
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        String name = null;
        for (String v : fqName.split("\\.")) {
            InteractionClass ic = OmtFunctions.getInteractionClass(modules, name = name == null ? v : name + "." + v);
            if (ic == null) {
                return null;
            }
            parameters.addAll(ic.getParameter());
        }
        return parameters;
    }

    public static BasicDataRepresentationsType.BasicData getBasicDataByName(ObjectModelType[] modules, String representationName) {
        for (ObjectModelType module : modules) {
            BasicDataRepresentationsType.BasicData basicData = OmtFunctions.getBasicDataByName(module, representationName);
            if (basicData == null) continue;
            return basicData;
        }
        return null;
    }

    public static BasicDataRepresentationsType.BasicData getBasicDataByName(ObjectModelType module, String representationName) {
        BasicDataRepresentationsType dt;
        if (module.getDataTypes() != null && (dt = module.getDataTypes().getBasicDataRepresentations()) != null) {
            List<BasicDataRepresentationsType.BasicData> list = dt.getBasicData();
            for (BasicDataRepresentationsType.BasicData e : list) {
                if (!e.getName().getValue().equals(representationName)) continue;
                return e;
            }
        }
        return null;
    }

    public static ObjectModelType getSimpleDataModule(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            if (OmtFunctions.getSimpleDataByName(module, datatypeName) == null) continue;
            return module;
        }
        return null;
    }

    public static SimpleDataTypesType.SimpleData getSimpleDataByName(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            SimpleDataTypesType.SimpleData simpleData = OmtFunctions.getSimpleDataByName(module, datatypeName);
            if (simpleData == null) continue;
            return simpleData;
        }
        return null;
    }

    public static SimpleDataTypesType.SimpleData getSimpleDataByName(ObjectModelType module, String datatypeName) {
        SimpleDataTypesType dt;
        if (module.getDataTypes() != null && (dt = module.getDataTypes().getSimpleDataTypes()) != null) {
            List<SimpleDataTypesType.SimpleData> list = dt.getSimpleData();
            for (SimpleDataTypesType.SimpleData e : list) {
                if (!e.getName().getValue().equals(datatypeName)) continue;
                return e;
            }
        }
        return null;
    }

    public static ObjectModelType getFixedRecordDataModule(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            if (OmtFunctions.getFixedRecordDataByName(module, datatypeName) == null) continue;
            return module;
        }
        return null;
    }

    public static FixedRecordDataTypesType.FixedRecordData getFixedRecordDataByName(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            FixedRecordDataTypesType.FixedRecordData fixedRecordData = OmtFunctions.getFixedRecordDataByName(module, datatypeName);
            if (fixedRecordData == null) continue;
            return fixedRecordData;
        }
        return null;
    }

    public static FixedRecordDataTypesType.FixedRecordData getFixedRecordDataByName(ObjectModelType module, String datatypeName) {
        FixedRecordDataTypesType dt;
        if (module.getDataTypes() != null && (dt = module.getDataTypes().getFixedRecordDataTypes()) != null) {
            List<FixedRecordDataTypesType.FixedRecordData> list = dt.getFixedRecordData();
            for (FixedRecordDataTypesType.FixedRecordData e : list) {
                if (!e.getName().getValue().equals(datatypeName)) continue;
                return e;
            }
        }
        return null;
    }

    public static ObjectModelType getVariantRecordDataModule(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            if (OmtFunctions.getVariantRecordDataByName(module, datatypeName) == null) continue;
            return module;
        }
        return null;
    }

    public static VariantRecordDataTypesType.VariantRecordData getVariantRecordDataByName(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            VariantRecordDataTypesType.VariantRecordData variantRecordData = OmtFunctions.getVariantRecordDataByName(module, datatypeName);
            if (variantRecordData == null) continue;
            return variantRecordData;
        }
        return null;
    }

    public static VariantRecordDataTypesType.VariantRecordData getVariantRecordDataByName(ObjectModelType module, String datatypeName) {
        VariantRecordDataTypesType dt;
        if (module.getDataTypes() != null && (dt = module.getDataTypes().getVariantRecordDataTypes()) != null) {
            List<VariantRecordDataTypesType.VariantRecordData> list = dt.getVariantRecordData();
            for (VariantRecordDataTypesType.VariantRecordData e : list) {
                if (!e.getName().getValue().equals(datatypeName)) continue;
                return e;
            }
        }
        return null;
    }

    public static ObjectModelType getEnumeratedDataModule(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            if (OmtFunctions.getEnumeratedDataByName(module, datatypeName) == null) continue;
            return module;
        }
        return null;
    }

    public static EnumeratedDataTypesType.EnumeratedData getEnumeratedDataByName(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            EnumeratedDataTypesType.EnumeratedData enumeratedData = OmtFunctions.getEnumeratedDataByName(module, datatypeName);
            if (enumeratedData == null) continue;
            return enumeratedData;
        }
        return null;
    }

    public static EnumeratedDataTypesType.EnumeratedData getEnumeratedDataByName(ObjectModelType module, String datatypeName) {
        EnumeratedDataTypesType dt;
        if (module.getDataTypes() != null && (dt = module.getDataTypes().getEnumeratedDataTypes()) != null) {
            List<EnumeratedDataTypesType.EnumeratedData> list = dt.getEnumeratedData();
            for (EnumeratedDataTypesType.EnumeratedData e : list) {
                if (!e.getName().getValue().equals(datatypeName)) continue;
                return e;
            }
        }
        return null;
    }

    public static ObjectModelType getArrayDataModule(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            if (OmtFunctions.getArrayDataByName(module, datatypeName) == null) continue;
            return module;
        }
        return null;
    }

    public static ArrayDataTypesType.ArrayData getArrayDataByName(ObjectModelType[] modules, String datatypeName) {
        for (ObjectModelType module : modules) {
            ArrayDataTypesType.ArrayData arrayData = OmtFunctions.getArrayDataByName(module, datatypeName);
            if (arrayData == null) continue;
            return arrayData;
        }
        return null;
    }

    public static ArrayDataTypesType.ArrayData getArrayDataByName(ObjectModelType module, String datatypeName) {
        DataTypesType.ArrayDataTypes dt;
        if (module.getDataTypes() != null && (dt = module.getDataTypes().getArrayDataTypes()) != null) {
            List<ArrayDataTypesType.ArrayData> list = dt.getArrayData();
            for (ArrayDataTypesType.ArrayData e : list) {
                if (!e.getName().getValue().equals(datatypeName)) continue;
                return e;
            }
        }
        return null;
    }

    public static TransportationsType.Transportation getTransportationByName(ObjectModelType module, String value) {
        List<TransportationsType.Transportation> list;
        if (module.getTransportations() != null && (list = module.getTransportations().getTransportation()) != null) {
            for (TransportationsType.Transportation e : list) {
                if (!e.getName().getValue().equals(value)) continue;
                return e;
            }
        }
        return null;
    }

    public static int[] geCardinality(ArrayDataTypesType.ArrayData dt) {
        try {
            String cardinality = dt.getCardinality().getValue();
            if (cardinality.equals("Dynamic")) {
                return new int[]{0, Integer.MAX_VALUE};
            }
            int first = cardinality.indexOf(91);
            int last = cardinality.lastIndexOf(93);
            if (first == -1 && last == -1) {
                int[] nArray;
                int v = Integer.parseInt(cardinality);
                if (v < 0) {
                    nArray = null;
                } else {
                    int[] nArray2 = new int[2];
                    nArray2[0] = v;
                    nArray = nArray2;
                    nArray2[1] = v;
                }
                return nArray;
            }
            if (first == -1 || last == -1) {
                return null;
            }
            String[] part = cardinality.substring(first + 1, last).split("\\.\\.");
            if (part == null || part.length != 2 || part[0] == null || part[1] == null) {
                return null;
            }
            return new int[]{Integer.parseInt(part[0]), Integer.parseInt(part[1])};
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static Set<String> getArrayDataTypesWithEncoding(ObjectModelType[] modules, Set<String> encodings) {
        HashSet<String> dataTypes = new HashSet<String>();
        for (ObjectModelType module : modules) {
            if (module.getDataTypes() == null || module.getDataTypes().getArrayDataTypes() == null || module.getDataTypes().getArrayDataTypes().getArrayData() == null) continue;
            for (ArrayDataTypesType.ArrayData arrayData : module.getDataTypes().getArrayDataTypes().getArrayData()) {
                if (!encodings.contains(arrayData.getEncoding().getValue())) continue;
                dataTypes.add(arrayData.getName().getValue());
            }
        }
        return dataTypes;
    }
}

