/*
 * Decompiled with CFR 0.152.
 */
package nl.tno.omt.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.tno.omt.ArrayDataTypesType;
import nl.tno.omt.EnumeratedDataTypesType;
import nl.tno.omt.FixedRecordDataTypesType;
import nl.tno.omt.ObjectModelType;
import nl.tno.omt.SimpleDataTypesType;
import nl.tno.omt.VariantRecordDataTypesType;
import nl.tno.omt.helpers.OmtFunctions;

public class OmtJavaMapping {
    private static final Map<String, JavaPrimitiveType> representationMap = new HashMap<String, JavaPrimitiveType>();
    private static final Map<String, JavaDataType> datatypeMap = new HashMap<String, JavaDataType>();

    public static void addRepresentations(Map<String, JavaPrimitiveType> representations) {
        representationMap.putAll(representations);
    }

    public static void addDatatype(String omtDatatypeName, String javaTypeName, Set<String> imports) {
        datatypeMap.put(omtDatatypeName, new JavaDataType(javaTypeName, imports));
    }

    public static JavaDataType getJavaDatatypeName(String omtDatatypeName) {
        return datatypeMap.get(omtDatatypeName);
    }

    public static String toJavaName(String omtName) {
        if (omtName.equals("Class")) {
            return "Class_";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        block4: while (i < omtName.length()) {
            switch (omtName.charAt(i)) {
                case '-': {
                    sb.append("_");
                    while (i < omtName.length() && omtName.charAt(i) == '-') {
                        sb.append("__");
                        ++i;
                    }
                    continue block4;
                }
                case '_': {
                    while (i < omtName.length() && omtName.charAt(i) == '_') {
                        sb.append("__");
                        ++i;
                    }
                    continue block4;
                }
            }
            sb.append(omtName.charAt(i++));
        }
        return sb.toString();
    }

    public static String toOmtName(String javaName) {
        if (javaName.equals("Class_")) {
            return "Class";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        block3: while (i < javaName.length()) {
            switch (javaName.charAt(i)) {
                case '_': {
                    int count = 0;
                    while (i < javaName.length() && javaName.charAt(i) == '_') {
                        ++count;
                        ++i;
                    }
                    char c = count % 2 == 0 ? (char)'_' : '-';
                    for (int j = 0; j < count / 2; ++j) {
                        sb.append(c);
                    }
                    continue block3;
                }
            }
            sb.append(javaName.charAt(i++));
        }
        return sb.toString();
    }

    public static String toJavaGetterName(String javaFieldName) {
        return "get" + javaFieldName.substring(0, 1).toUpperCase() + javaFieldName.substring(1);
    }

    public static String toJavaSetterName(String javaFieldName) {
        return "set" + javaFieldName.substring(0, 1).toUpperCase() + javaFieldName.substring(1);
    }

    public static String getJavaDatatypeName(ObjectModelType[] modules, String omtDatatypeName, int dimension, boolean useList, boolean useBoxed) throws Exception {
        if (dimension == 0) {
            return OmtJavaMapping.getJavaDatatypeName(modules, omtDatatypeName, useBoxed);
        }
        if (useList) {
            int i;
            Object javaDatatypeName = "";
            for (i = 0; i < dimension; ++i) {
                javaDatatypeName = (String)javaDatatypeName + "List<";
            }
            javaDatatypeName = (String)javaDatatypeName + OmtJavaMapping.getJavaDatatypeName(modules, omtDatatypeName, true);
            for (i = 0; i < dimension; ++i) {
                javaDatatypeName = (String)javaDatatypeName + ">";
            }
            return javaDatatypeName;
        }
        Object javaDatatypeName = OmtJavaMapping.getJavaDatatypeName(modules, omtDatatypeName, false);
        for (int i = 0; i < dimension; ++i) {
            javaDatatypeName = (String)javaDatatypeName + "[]";
        }
        return javaDatatypeName;
    }

    public static String getJavaDatatypeNameForEnumerationType(ObjectModelType[] modules, String omtDatatypeName, boolean useBoxed) throws Exception {
        EnumeratedDataTypesType.EnumeratedData enumeratedData = OmtFunctions.getEnumeratedDataByName(modules, omtDatatypeName);
        if (enumeratedData != null) {
            if (omtDatatypeName.equals("HLAboolean")) {
                return useBoxed ? "Boolean" : "boolean";
            }
            return omtDatatypeName;
        }
        throw new Exception("Unknown enumeration type " + omtDatatypeName);
    }

    public static String getJavaDatatypeName(ObjectModelType[] modules, String omtDatatypeName, boolean useBoxed) throws Exception {
        JavaDataType javaDatatype = datatypeMap.get(omtDatatypeName);
        if (javaDatatype != null) {
            return javaDatatype.getDatatypeName();
        }
        SimpleDataTypesType.SimpleData simpleData = OmtFunctions.getSimpleDataByName(modules, omtDatatypeName);
        if (simpleData != null) {
            return OmtJavaMapping.getJavaDatatypeNameForRepresentation(simpleData.getRepresentation().getValue(), useBoxed);
        }
        FixedRecordDataTypesType.FixedRecordData fixedRecordData = OmtFunctions.getFixedRecordDataByName(modules, omtDatatypeName);
        if (fixedRecordData != null) {
            return omtDatatypeName;
        }
        VariantRecordDataTypesType.VariantRecordData variantRecordData = OmtFunctions.getVariantRecordDataByName(modules, omtDatatypeName);
        if (variantRecordData != null) {
            return omtDatatypeName;
        }
        EnumeratedDataTypesType.EnumeratedData enumeratedData = OmtFunctions.getEnumeratedDataByName(modules, omtDatatypeName);
        if (enumeratedData != null) {
            if (omtDatatypeName.equals("HLAboolean")) {
                return useBoxed ? "Boolean" : "boolean";
            }
            return omtDatatypeName;
        }
        ArrayDataTypesType.ArrayData arrayData = OmtFunctions.getArrayDataByName(modules, omtDatatypeName);
        if (arrayData != null) {
            if (arrayData.getDataType().getValue().equals("HLAunicodeChar") || arrayData.getDataType().getValue().equals("HLAASCIIchar")) {
                return "String";
            }
            throw new Exception("Expected character type, but got " + omtDatatypeName);
        }
        throw new Exception("Unknown datatype " + omtDatatypeName);
    }

    public static String getJavaDatatypeNameForRepresentation(String omtRepresentatioName, boolean useBoxed) throws Exception {
        JavaPrimitiveType javaType = representationMap.get(omtRepresentatioName);
        if (javaType != null) {
            return useBoxed ? javaType.getBoxdedType() : javaType.getUnboxedType();
        }
        throw new Exception("Unknown representation " + omtRepresentatioName);
    }

    static {
        representationMap.put("HLAoctet", JavaPrimitiveType.BYTE);
        representationMap.put("HLAinteger16BE", JavaPrimitiveType.SHORT);
        representationMap.put("HLAinteger32BE", JavaPrimitiveType.INTEGER);
        representationMap.put("HLAinteger64BE", JavaPrimitiveType.LONG);
        representationMap.put("HLAunsignedInteger16BE", JavaPrimitiveType.SHORT);
        representationMap.put("HLAunsignedInteger32BE", JavaPrimitiveType.INTEGER);
        representationMap.put("HLAunsignedInteger64BE", JavaPrimitiveType.LONG);
        representationMap.put("HLAfloat32BE", JavaPrimitiveType.FLOAT);
        representationMap.put("HLAfloat64BE", JavaPrimitiveType.DOUBLE);
        representationMap.put("HLAoctetPairBE", JavaPrimitiveType.CHARACTER);
    }

    public static class JavaDataType {
        String datatypeName;
        Set<String> imports;

        public JavaDataType(String datatypeName, Set<String> imports) {
            this.datatypeName = datatypeName;
            this.imports = imports;
        }

        public String getDatatypeName() {
            return this.datatypeName;
        }

        public Set<String> getImports() {
            return this.imports;
        }
    }

    public static enum JavaPrimitiveType {
        BYTE("byte", "Byte"),
        SHORT("short", "Short"),
        INTEGER("int", "Integer"),
        LONG("long", "Long"),
        FLOAT("float", "Float"),
        DOUBLE("double", "Double"),
        CHARACTER("char", "Character");

        private final String unboxedType;
        private final String boxedType;

        private JavaPrimitiveType(String unboxedType, String boxedType) {
            this.unboxedType = unboxedType;
            this.boxedType = boxedType;
        }

        public String getUnboxedType() {
            return this.unboxedType;
        }

        public String getBoxdedType() {
            return this.boxedType;
        }
    }
}

