/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.test.context.junit4.AbstractTransactionalJUnit4SpringContextTests;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractDefaultTestPart
extends AbstractTransactionalJUnit4SpringContextTests {
    private static final Log log = LogFactory.getLog(AbstractDefaultTestPart.class);
    protected static List<String> SQL_SCRIPTS;
    protected static List<String> SQL_CLEAN_UP_SCRIPTS;
    protected static String host;

    protected static ConfigurableApplicationContext loadContext(String[] locations) {
        return new ClassPathXmlApplicationContext(locations);
    }

    @BeforeClass
    public static void runOnce() throws Exception {
        if (StringUtils.contains((String)host, (String)"localhost") || StringUtils.contains((String)host, (String)"127.0.0.")) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Starting up the application context...");
            }
            try {
                ConfigurableApplicationContext context = AbstractDefaultTestPart.loadContext(new String[]{"itest-sql-script-context.xml"});
                if (log.isInfoEnabled()) {
                    log.info((Object)"Retrieving available SQL scripts...");
                }
                try {
                    SQL_SCRIPTS = (List)context.getBean("sqlScripts");
                }
                catch (NoSuchBeanDefinitionException e) {
                    SQL_SCRIPTS = new ArrayList<String>(0);
                }
                try {
                    SQL_CLEAN_UP_SCRIPTS = (List)context.getBean("sqlCleanUpScripts");
                }
                catch (NoSuchBeanDefinitionException e) {
                    SQL_CLEAN_UP_SCRIPTS = new ArrayList<String>(0);
                }
                int numberOfScripts = SQL_SCRIPTS.size() + SQL_CLEAN_UP_SCRIPTS.size();
                if (log.isInfoEnabled()) {
                    log.info((Object)(numberOfScripts + " SQL scripts retrieved..."));
                }
            }
            catch (BeansException e) {
                String msg = "Failed to start up the application context! - " + e.getMessage();
                if (log.isErrorEnabled()) {
                    log.error((Object)msg);
                }
                Assert.fail((String)msg);
            }
        }
    }

    @Before
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executeSQLScripts() throws Exception {
        for (String script : SQL_SCRIPTS) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Executing script: " + script));
            }
            this.executeSqlScript(script, false);
        }
    }

    @After
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executeSQLCleanUpScripts() throws Exception {
        for (String script : SQL_CLEAN_UP_SCRIPTS) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Executing clean up script: " + script));
            }
            this.executeSqlScript(script, false);
        }
    }

    static {
        host = "localhost:8890";
    }
}

