/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest;

import junit.framework.Assert;
import nl.tranquilizedquality.itest.cargo.ContainerUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class AbstractDefaultNoDbDeploymentTest {
    private static final Log log = LogFactory.getLog(AbstractDefaultNoDbDeploymentTest.class);
    protected static ContainerUtil CONTAINER_UTIL;
    protected static String host;
    protected static String ITEST_CONTEXT_FILENAME;

    protected static ConfigurableApplicationContext loadContext(String[] locations) {
        return new ClassPathXmlApplicationContext(locations);
    }

    @BeforeClass
    public static void runOnce() throws Exception {
        if (StringUtils.contains((String)host, (String)"localhost") || StringUtils.contains((String)host, (String)"127.0.0.")) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Starting up the container utility...");
            }
            try {
                ConfigurableApplicationContext context = AbstractDefaultNoDbDeploymentTest.loadContext(new String[]{ITEST_CONTEXT_FILENAME, "common-itest-context.xml"});
                CONTAINER_UTIL = (ContainerUtil)context.getBean("containerUtil");
                CONTAINER_UTIL.start();
            }
            catch (BeansException e) {
                String msg = "Failed to start up the container utility! - " + e.getMessage();
                if (log.isErrorEnabled()) {
                    log.error((Object)msg);
                }
                Assert.fail((String)msg);
            }
        }
    }

    @AfterClass
    public static void stop() {
        if (CONTAINER_UTIL != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Stopping the container utility...");
            }
            CONTAINER_UTIL.stop();
        }
    }

    static {
        host = "localhost:8890";
        ITEST_CONTEXT_FILENAME = "itest-context.xml";
    }
}

