/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest.cargo;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.tranquilizedquality.itest.cargo.ContainerUtil;
import nl.tranquilizedquality.itest.cargo.exception.ConfigurationException;
import nl.tranquilizedquality.itest.domain.DeployableLocationConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.springframework.beans.factory.annotation.Required;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInstalledContainerUtil
implements ContainerUtil {
    private static final Log LOGGER = LogFactory.getLog(AbstractInstalledContainerUtil.class);
    private String containerName;
    protected String configResourcesPath = "src/test/resources/";
    protected InstalledLocalContainer installedLocalContainer;
    protected List<String> jvmArguments = new ArrayList<String>();
    protected String containerHome;
    protected Integer containerPort;
    protected String cargoLogFilePath;
    protected Map<String, String> systemProperties = new HashMap<String, String>();
    protected String remoteLocation;
    protected String containerFile;
    protected Map<String, String> deployableLocations = new LinkedHashMap<String, String>();
    protected List<DeployableLocationConfiguration> deployableLocationConfigurations = new ArrayList<DeployableLocationConfiguration>();
    private boolean cleanUpAfterContainerStopped = true;
    private String containerRootFolderName;

    private void cleanUpContainer() {
        block2: {
            try {
                FileUtils.deleteDirectory((File)new File(this.containerRootFolderName));
            }
            catch (Exception exceptionOnDelete) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error((Object)("Failed to delete the directory: " + this.containerHome + "."), (Throwable)exceptionOnDelete);
            }
        }
    }

    protected void setupContainerHome() {
        String operatingSystem = System.getProperty("os.name");
        StringBuilder builder = new StringBuilder();
        if (operatingSystem != null && operatingSystem.startsWith("Windows")) {
            builder.append("C:/WINDOWS/Temp/");
        } else {
            builder.append("/tmp/");
        }
        Long timeStamp = Calendar.getInstance().getTimeInMillis();
        builder.append(timeStamp);
        builder.append("/");
        this.containerRootFolderName = builder.toString();
        builder.append(this.containerName);
        builder.append("/");
        this.containerHome = builder.toString();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Container HOME: " + this.containerHome));
        }
    }

    protected abstract void setupConfiguration() throws Exception;

    protected void setupContainer() throws Exception {
        boolean renamed;
        String operatingSystem;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Cleaning up " + this.containerName + "..."));
        }
        if ((operatingSystem = System.getProperty("os.name")) != null && !operatingSystem.startsWith("Windows")) {
            try {
                new File(this.containerHome).mkdir();
            }
            catch (Exception exceptionOnMkDir) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)("Failed to create the directory: " + this.containerHome + ". Details: " + exceptionOnMkDir.getMessage()), (Throwable)exceptionOnMkDir);
                }
                throw new ConfigurationException("Failed to create the directory: " + this.containerHome + ". Details: " + exceptionOnMkDir.getMessage(), exceptionOnMkDir);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Installing " + this.containerName + "..."));
            LOGGER.info((Object)("Downloading container from: " + this.remoteLocation));
            LOGGER.info((Object)("Container file: " + this.containerFile));
        }
        URL remoteLocation = new URL(this.remoteLocation + this.containerFile);
        String installDir = StringUtils.substringBeforeLast((String)StringUtils.chomp((String)this.containerHome, (String)"/"), (String)"/");
        ZipURLInstaller installer = new ZipURLInstaller(remoteLocation, installDir, installDir);
        installer.install();
        String containerDir = StringUtils.stripEnd((String)this.containerFile, (String)".zip");
        File installedDir = new File(installDir + "/" + containerDir + "/");
        File destenationDir = new File(this.containerHome);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Renaming: " + installedDir.getPath()));
            LOGGER.info((Object)("To: " + destenationDir.getPath()));
        }
        if (!(renamed = installedDir.renameTo(destenationDir))) {
            String msg = "Failed to rename container install directory to home directory name!";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to rename container install directory to home directory name!");
            }
            throw new ConfigurationException("Failed to rename container install directory to home directory name!");
        }
        this.systemProperties.put("cargo.server.port", this.containerPort.toString());
    }

    protected abstract void deploy();

    @Override
    public void start() throws Exception {
        this.setupContainer();
        this.deploy();
    }

    @Override
    public void stop() {
        this.installedLocalContainer.stop();
        if (this.cleanUpAfterContainerStopped) {
            this.cleanUpContainer();
        }
    }

    public void setConfigResourcesPath(String configResourcesPath) {
        this.configResourcesPath = configResourcesPath;
    }

    public String getConfigResourcesPath() {
        return this.configResourcesPath;
    }

    public void setDeployableLocations(Map<String, String> deployableLocations) {
        this.deployableLocations = deployableLocations;
    }

    public void setDeployableLocationConfigurations(List<DeployableLocationConfiguration> deployableLocationConfigurations) {
        this.deployableLocationConfigurations = deployableLocationConfigurations;
    }

    @Override
    public void addDeployableLocation(String location, String type) {
        this.deployableLocations.put(type, location);
    }

    @Override
    public Integer getContainerPort() {
        return this.containerPort;
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public List<String> getJvmArguments() {
        return Collections.unmodifiableList(this.jvmArguments);
    }

    @Required
    public void setJvmArguments(List<String> jvmArguments) {
        this.jvmArguments = new ArrayList<String>(jvmArguments);
    }

    @Required
    public void setCargoLogFilePath(String cargoLogFilePath) {
        this.cargoLogFilePath = cargoLogFilePath;
    }

    @Required
    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    @Required
    public void setRemoteLocation(String remoteLocation) {
        this.remoteLocation = remoteLocation;
    }

    @Required
    public void setContainerFile(String containerFile) {
        this.containerFile = containerFile;
    }

    public void setCleanUpAfterContainerStopped(boolean cleanUpAfterContainerStopped) {
        this.cleanUpAfterContainerStopped = cleanUpAfterContainerStopped;
    }

    protected void setContainerName(String containerName) {
        this.containerName = containerName;
    }
}

