/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest.cargo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.tranquilizedquality.itest.cargo.AbstractInstalledContainerUtil;
import nl.tranquilizedquality.itest.cargo.exception.ConfigurationException;
import nl.tranquilizedquality.itest.cargo.exception.DeployException;
import nl.tranquilizedquality.itest.domain.DeployableLocationConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJBossContainerUtil
extends AbstractInstalledContainerUtil {
    private static final Log LOGGER = LogFactory.getLog(AbstractJBossContainerUtil.class);
    private static final String PROPERTIES_FILES_SUFFIX = ".properties";
    private static final String LOG4J_XML = "log4j.xml";
    private static final String DATA_SOURCE_FILES_SUFFIX = "-ds.xml";
    private Integer jnpPort;
    private String containerConfigurationFile;
    private boolean autoDetect = true;
    protected String configurationName;

    public AbstractJBossContainerUtil() {
        this.setContainerName("JBoss");
        this.setupContainerHome();
    }

    @Override
    protected void setupContainer() throws Exception {
        super.setupContainer();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Downloading configuration from: " + this.remoteLocation));
            LOGGER.info((Object)("Container configuration file: " + this.containerConfigurationFile));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Installing [" + this.configurationName + "] configuration..."));
        }
        URL remoteLocation = new URL(this.remoteLocation + this.containerConfigurationFile);
        String installDir = this.containerHome + "server/";
        ZipURLInstaller installer = new ZipURLInstaller(remoteLocation, installDir, installDir);
        installer.install();
        this.systemProperties.put("jboss.server.lib.url:lib", "file:lib/");
        this.systemProperties.put("cargo.jnp.port", this.jnpPort.toString());
        if (this.autoDetect) {
            this.copyResourceFileToConfDir(LOG4J_XML);
            List<String> dataSourceFiles = this.findConfigurationFiles(DATA_SOURCE_FILES_SUFFIX);
            for (String fileName : dataSourceFiles) {
                String deployDirectory = this.getContainerDirectory("deploy/");
                this.copyResourceFile(fileName, deployDirectory);
            }
            List<String> propertiesFiles = this.findConfigurationFiles(PROPERTIES_FILES_SUFFIX);
            for (String fileName : propertiesFiles) {
                this.copyResourceFileToConfDir(fileName);
            }
        }
        this.setupConfiguration();
    }

    protected List<String> findConfigurationFiles(String suffix) {
        File[] listFiles;
        ArrayList<String> files = new ArrayList<String>();
        File directory = new File(this.configResourcesPath);
        for (File file : listFiles = directory.listFiles()) {
            String name = file.getName();
            if (!StringUtils.endsWithIgnoreCase((String)name, (String)suffix)) continue;
            files.add(name);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info((Object)("Added configuration file called: " + name));
        }
        return files;
    }

    protected void copyResourceFileToConfDir(String fileName) {
        this.copyResourceFile(fileName, this.getConfDirectory());
    }

    protected void copyResourceFile(String fileName, String destinationDirectory) {
        block3: {
            String originalFile = this.configResourcesPath + fileName;
            File srcFile = new File(originalFile);
            String newFile = destinationDirectory + fileName;
            File destFile = new File(newFile);
            try {
                FileUtils.copyFile((File)srcFile, (File)destFile);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Copied file " + fileName + " to " + destFile.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn((Object)("Failed to copy resource file: " + fileName));
            }
        }
    }

    @Override
    protected void deploy() {
        DefaultConfigurationFactory configurationFactory = new DefaultConfigurationFactory();
        LocalConfiguration configuration = (LocalConfiguration)configurationFactory.createConfiguration("jboss4x", ContainerType.INSTALLED, ConfigurationType.EXISTING, this.containerHome + "server/" + this.configurationName);
        StringBuilder args = new StringBuilder();
        for (String arg : this.jvmArguments) {
            args.append(arg);
            args.append(" ");
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info((Object)("Added JVM argument: " + arg));
        }
        configuration.setProperty("cargo.jvmargs", args.toString());
        configuration.setProperty("cargo.servlet.port", this.containerPort.toString());
        Set entrySet = this.deployableLocations.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            DeployableType deployableType = null;
            deployableType = this.determineDeployableType(value);
            this.addDeployable(configuration, key, deployableType);
        }
        for (DeployableLocationConfiguration config : this.deployableLocationConfigurations) {
            String contextName = config.getContextName();
            String type = config.getType();
            String path = config.getPath();
            DeployableType deployableType = null;
            if (contextName != null && contextName.length() > 0) {
                deployableType = this.determineDeployableType(type);
                if (DeployableType.WAR.equals((Object)deployableType)) {
                    File srcFile = new File(path);
                    File destFile = new File("target/" + contextName + ".war");
                    try {
                        FileUtils.copyFile((File)srcFile, (File)destFile);
                    }
                    catch (IOException e) {
                        throw new DeployException("Failed to copy WAR file: " + path, e);
                    }
                    path = destFile.getPath();
                }
            } else {
                deployableType = this.determineDeployableType(type);
            }
            this.addDeployable(configuration, path, deployableType);
        }
        this.installedLocalContainer = (InstalledLocalContainer)new DefaultContainerFactory().createContainer("jboss4x", ContainerType.INSTALLED, (Configuration)configuration);
        this.installedLocalContainer.setHome(this.containerHome);
        FileLogger fileLogger = new FileLogger(new File(this.cargoLogFilePath + "cargo.log"), true);
        fileLogger.setLevel(LogLevel.DEBUG);
        this.installedLocalContainer.setLogger((Logger)fileLogger);
        this.installedLocalContainer.setOutput(this.cargoLogFilePath + "output.log");
        this.installedLocalContainer.setSystemProperties(this.systemProperties);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Starting JBoss [" + this.configurationName + "]..."));
        }
        this.installedLocalContainer.start();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"JBoss up and running!");
        }
    }

    private DeployableType determineDeployableType(String type) {
        DeployableType deployableType = "EAR".equals(type) ? DeployableType.EAR : ("WAR".equals(type) ? DeployableType.WAR : ("EJB".equals(type) ? DeployableType.EJB : DeployableType.EAR));
        return deployableType;
    }

    private void addDeployable(LocalConfiguration configuration, String path, DeployableType deployableType) {
        Deployable deployable = new DefaultDeployableFactory().createDeployable(this.configurationName, path, deployableType);
        configuration.addDeployable(deployable);
    }

    @Required
    public void setContainerConfigurationFile(String containerConfigurationFile) {
        this.containerConfigurationFile = containerConfigurationFile;
    }

    @Required
    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    @Required
    public void setJnpPort(Integer jnpPort) {
        this.jnpPort = jnpPort;
    }

    private String getContainerDirectory(String dir) {
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(this.containerHome);
        fullPath.append("server/");
        fullPath.append(this.configurationName);
        fullPath.append("/");
        fullPath.append(dir);
        String path = fullPath.toString();
        File directory = new File(path);
        if (!directory.exists()) {
            String msg = dir + " directory does not excist! : " + path;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)msg);
            }
            throw new ConfigurationException(msg);
        }
        return path;
    }

    @Override
    public String getSharedLibDirectory() {
        return this.getContainerDirectory("lib/");
    }

    @Override
    public String getConfDirectory() {
        return this.getContainerDirectory("conf/");
    }

    public void setAutoDetect(boolean autoDetect) {
        this.autoDetect = autoDetect;
    }
}

