/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest.cargo;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import nl.tranquilizedquality.itest.cargo.AbstractInstalledContainerUtil;
import nl.tranquilizedquality.itest.cargo.exception.ConfigurationException;
import nl.tranquilizedquality.itest.cargo.exception.DeployException;
import nl.tranquilizedquality.itest.domain.DeployableLocationConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;
import org.springframework.beans.factory.annotation.Required;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTomcatContainerUtil
extends AbstractInstalledContainerUtil {
    private static final Log LOGGER = LogFactory.getLog(AbstractTomcatContainerUtil.class);
    protected Integer ajpPort;
    protected Integer rmiPort;
    protected String tomcatVersion;

    public AbstractTomcatContainerUtil() {
        this.setContainerName("Tomcat");
        this.setupContainerHome();
    }

    @Override
    protected void setupContainer() throws Exception {
        super.setupContainer();
        this.systemProperties.put("cargo.tomcat.ajp.port", this.ajpPort.toString());
        this.systemProperties.put("cargo.rmi.port", this.rmiPort.toString());
        this.setupConfiguration();
    }

    @Override
    protected void deploy() {
        DefaultConfigurationFactory configurationFactory = new DefaultConfigurationFactory();
        LocalConfiguration configuration = (LocalConfiguration)configurationFactory.createConfiguration(this.tomcatVersion, ContainerType.INSTALLED, ConfigurationType.EXISTING, this.containerHome);
        StringBuilder args = new StringBuilder();
        for (String arg : this.jvmArguments) {
            args.append(arg);
            args.append(" ");
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info((Object)("Added JVM argument: " + arg));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"== CONFIGURATION PROPERTIES ==");
            LOGGER.debug((Object)("CONTAINER PORT : " + this.containerPort));
            LOGGER.debug((Object)("AJP PORT       : " + this.ajpPort));
            LOGGER.debug((Object)("RMI PORT       : " + this.rmiPort));
        }
        configuration.setProperty("cargo.jvmargs", args.toString());
        configuration.setProperty("cargo.servlet.port", this.containerPort.toString());
        configuration.setProperty("cargo.tomcat.ajp.port", this.ajpPort.toString());
        configuration.setProperty("cargo.rmi.port", this.rmiPort.toString());
        Set entrySet = this.deployableLocations.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            DeployableType deployableType = null;
            deployableType = this.determineDeployableType(value);
            this.addDeployable(configuration, key, deployableType);
        }
        for (DeployableLocationConfiguration config : this.deployableLocationConfigurations) {
            String contextName = config.getContextName();
            String type = config.getType();
            String path = config.getPath();
            DeployableType deployableType = null;
            if (contextName != null && contextName.length() > 0) {
                deployableType = this.determineDeployableType(type);
                if (DeployableType.WAR.equals((Object)deployableType)) {
                    File srcFile = new File(path);
                    File destFile = new File("target/" + contextName + ".war");
                    try {
                        FileUtils.copyFile((File)srcFile, (File)destFile);
                    }
                    catch (IOException e) {
                        throw new DeployException("Failed to copy WAR file: " + path, e);
                    }
                    try {
                        FileUtils.copyFile((File)srcFile, (File)destFile);
                    }
                    catch (IOException e) {
                        throw new DeployException("Failed to copy WAR file: " + path, e);
                    }
                    path = destFile.getPath();
                }
            } else {
                deployableType = this.determineDeployableType(type);
            }
            this.addDeployable(configuration, path, deployableType);
        }
        this.installedLocalContainer = (InstalledLocalContainer)new DefaultContainerFactory().createContainer("tomcat5x", ContainerType.INSTALLED, (Configuration)configuration);
        this.installedLocalContainer = (InstalledLocalContainer)new DefaultContainerFactory().createContainer(this.tomcatVersion, ContainerType.INSTALLED, (Configuration)configuration);
        this.installedLocalContainer.setHome(this.containerHome);
        FileLogger fileLogger = new FileLogger(new File(this.cargoLogFilePath + "cargo.log"), true);
        fileLogger.setLevel(LogLevel.DEBUG);
        this.installedLocalContainer.setLogger((Logger)fileLogger);
        this.installedLocalContainer.setOutput(this.cargoLogFilePath + "output.log");
        this.installedLocalContainer.setSystemProperties(this.systemProperties);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting Tomcat ...");
        }
        this.installedLocalContainer.start();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Tomcat up and running!");
        }
    }

    public Map<String, String> getDeployableLocations() {
        return this.deployableLocations;
    }

    private DeployableType determineDeployableType(String type) {
        DeployableType deployableType;
        if ("EAR".equals(type)) {
            throw new DeployException("Tomcat doesn't support EAR files!");
        }
        if ("WAR".equals(type)) {
            deployableType = DeployableType.WAR;
        } else {
            if ("EJB".equals(type)) {
                throw new DeployException("Tomcat doesn't support EJB files!");
            }
            deployableType = DeployableType.WAR;
        }
        return deployableType;
    }

    private void addDeployable(LocalConfiguration configuration, String path, DeployableType deployableType) {
        Deployable deployable = new DefaultDeployableFactory().createDeployable("jetty", path, deployableType);
        configuration.addDeployable(deployable);
    }

    private String getContainerDirectory(String dir) {
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(this.containerHome);
        fullPath.append(dir);
        String path = fullPath.toString();
        File directory = new File(path);
        if (!directory.exists()) {
            String msg = dir + " directory does not excist! : " + path;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)msg);
            }
            throw new ConfigurationException(msg);
        }
        return path;
    }

    @Override
    public String getSharedLibDirectory() {
        return this.getContainerDirectory("lib/");
    }

    @Override
    public String getConfDirectory() {
        return this.getContainerDirectory("conf/");
    }

    public void setTomcatVersion(String tomcatVersion) {
        this.tomcatVersion = tomcatVersion;
    }

    public Integer getAjpPort() {
        return this.ajpPort;
    }

    @Required
    public void setAjpPort(Integer ajpPort) {
        this.ajpPort = ajpPort;
    }

    public Integer getRmiPort() {
        return this.rmiPort;
    }

    @Required
    public void setRmiPort(Integer rmiPort) {
        this.rmiPort = rmiPort;
    }
}

