/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest;

import nl.tranquilizedquality.itest.cargo.ContainerUtil;
import nl.tranquilizedquality.itest.domain.SQLScripts;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.junit4.AbstractTransactionalJUnit4SpringContextTests;

public abstract class AbstractDefaultDeploymentTest
extends AbstractTransactionalJUnit4SpringContextTests {
    private static final Log LOGGER = LogFactory.getLog(AbstractDefaultDeploymentTest.class);
    protected static ContainerUtil CONTAINER_UTIL;
    @Autowired(required=false)
    private SQLScripts sqlScripts;
    protected static ConfigurableApplicationContext CONTEXT;
    protected static String host;

    public static boolean isRunningOnLocalHost() {
        return StringUtils.contains((String)host, (String)"localhost") || StringUtils.contains((String)host, (String)"127.0.0.");
    }

    @AfterClass
    public static void stop() {
        if (AbstractDefaultDeploymentTest.isRunningOnLocalHost()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Stopping the container utility...");
            }
            CONTAINER_UTIL.stop();
        }
        if (CONTEXT != null) {
            CONTEXT.close();
        }
    }

    @Before
    public void executeSQLScripts() {
        if (this.sqlScripts != null) {
            for (String script : this.sqlScripts.getSetupScripts()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Executing script: " + script));
                }
                this.executeSqlScript(script, false);
            }
        }
    }

    @After
    public void executeSQLCleanUpScripts() {
        if (this.sqlScripts != null) {
            for (String script : this.sqlScripts.getCleanUpScripts()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Executing clean up script: " + script));
                }
                this.executeSqlScript(script, false);
            }
        }
    }

    static {
        host = "localhost:8890";
    }
}

