/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest;

import nl.tranquilizedquality.itest.cargo.ContainerUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public abstract class AbstractDefaultNoDbDeploymentTest {
    private static final Log LOGGER = LogFactory.getLog(AbstractDefaultNoDbDeploymentTest.class);
    protected static ContainerUtil CONTAINER_UTIL;
    protected static String host;
    protected static Class<?>[] CONFIGURATION_CLASSES;
    protected static ConfigurableApplicationContext CONTEXT;

    public static boolean isRunningOnLocalHost() {
        return StringUtils.contains((String)host, (String)"localhost") || StringUtils.contains((String)host, (String)"127.0.0.");
    }

    public static void startupContainer() {
        if (AbstractDefaultNoDbDeploymentTest.isRunningOnLocalHost()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Starting up the container utility...");
            }
            try {
                CONTEXT = new AnnotationConfigApplicationContext((Class[])CONFIGURATION_CLASSES);
                CONTAINER_UTIL = (ContainerUtil)CONTEXT.getBean("containerUtil");
                CONTAINER_UTIL.start();
            }
            catch (BeansException e) {
                String msg = "Failed to start up the container utility! - " + e.getMessage();
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error((Object)msg, (Throwable)e);
                }
                Assert.fail((String)msg);
            }
        }
    }

    @AfterClass
    public static void stop() {
        if (CONTAINER_UTIL != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"Stopping the container utility...");
            }
            CONTAINER_UTIL.stop();
        }
        if (CONTEXT != null) {
            CONTEXT.close();
        }
    }

    static {
        host = "localhost:8890";
    }
}

