/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest;

import nl.tranquilizedquality.itest.configuration.DatasourceConfiguration;
import nl.tranquilizedquality.itest.configuration.SQLScriptsConfiguration;
import nl.tranquilizedquality.itest.domain.SQLScripts;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractTransactionalJUnit4SpringContextTests;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={DatasourceConfiguration.class, SQLScriptsConfiguration.class})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public abstract class AbstractDefaultTestPart
extends AbstractTransactionalJUnit4SpringContextTests {
    private static final Log LOGGER = LogFactory.getLog(AbstractDefaultTestPart.class);
    @Autowired(required=false)
    private SQLScripts sqlScripts;
    protected static String host = "localhost:8890";

    public static boolean isRunningOnLocalHost() {
        return StringUtils.contains((String)host, (String)"localhost") || StringUtils.contains((String)host, (String)"127.0.0.");
    }

    @Before
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executeSQLScripts() {
        if (this.sqlScripts != null) {
            for (String script : this.sqlScripts.getSetupScripts()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Executing script: " + script));
                }
                this.executeSqlScript(script, false);
            }
        }
    }

    @After
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executeSQLCleanUpScripts() {
        if (this.sqlScripts != null) {
            for (String script : this.sqlScripts.getCleanUpScripts()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Executing clean up script: " + script));
                }
                this.executeSqlScript(script, false);
            }
        }
    }
}

