/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest.cargo;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import nl.tranquilizedquality.itest.cargo.AbstractInstalledContainerUtil;
import nl.tranquilizedquality.itest.cargo.exception.ConfigurationException;
import nl.tranquilizedquality.itest.cargo.exception.DeployException;
import nl.tranquilizedquality.itest.domain.DeployableLocationConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.util.log.FileLogger;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractJOnasContainerUtil
extends AbstractInstalledContainerUtil {
    private static final Log LOGGER = LogFactory.getLog(AbstractJOnasContainerUtil.class);
    protected String configurationName;

    public AbstractJOnasContainerUtil() {
        this.setContainerName("JOnas");
        this.setupContainerHome();
    }

    @Override
    protected void setupContainer() {
        super.setupContainer();
        this.setupConfiguration();
    }

    @Override
    protected void deploy() {
        DefaultConfigurationFactory configurationFactory = new DefaultConfigurationFactory();
        LocalConfiguration configuration = (LocalConfiguration)configurationFactory.createConfiguration("jonas4x", ContainerType.INSTALLED, ConfigurationType.EXISTING, this.containerHome);
        StringBuilder args = new StringBuilder();
        for (String arg : this.jvmArguments) {
            args.append(arg);
            args.append(" ");
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info((Object)("Added JVM argument: " + arg));
        }
        configuration.setProperty("cargo.jvmargs", args.toString());
        configuration.setProperty("cargo.servlet.port", this.containerPort.toString());
        Set entrySet = this.deployableLocations.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            DeployableType deployableType = null;
            deployableType = this.determineDeployableType(value);
            this.addDeployable(configuration, key, deployableType);
        }
        for (DeployableLocationConfiguration config : this.deployableLocationConfigurations) {
            String contextName = config.getContextName();
            String type = config.getType();
            String path = config.getPath();
            DeployableType deployableType = null;
            if (contextName != null && contextName.length() > 0) {
                deployableType = this.determineDeployableType(type);
                if (DeployableType.WAR.equals((Object)deployableType)) {
                    File srcFile = new File(path);
                    File destFile = new File("target/" + contextName + ".war");
                    try {
                        FileUtils.copyFile((File)srcFile, (File)destFile);
                    }
                    catch (IOException e) {
                        throw new DeployException("Failed to copy WAR file: " + path, e);
                    }
                    path = destFile.getPath();
                }
            } else {
                deployableType = this.determineDeployableType(type);
            }
            this.addDeployable(configuration, path, deployableType);
        }
        this.installedLocalContainer = (InstalledLocalContainer)new DefaultContainerFactory().createContainer("jonas4x", ContainerType.INSTALLED, (Configuration)configuration);
        this.installedLocalContainer.setHome(this.containerHome);
        FileLogger fileLogger = new FileLogger(new File(this.cargoLogFilePath + "cargo.log"), true);
        fileLogger.setLevel(LogLevel.DEBUG);
        this.installedLocalContainer.setLogger((Logger)fileLogger);
        this.installedLocalContainer.setOutput(this.cargoLogFilePath + "output.log");
        this.installedLocalContainer.setSystemProperties(this.systemProperties);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Starting JOnas [" + this.configurationName + "]..."));
        }
        this.installedLocalContainer.start();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"JOnas up and running!");
        }
    }

    private DeployableType determineDeployableType(String type) {
        DeployableType deployableType = "EAR".equals(type) ? DeployableType.EAR : ("WAR".equals(type) ? DeployableType.WAR : ("EJB".equals(type) ? DeployableType.EJB : DeployableType.EAR));
        return deployableType;
    }

    private void addDeployable(LocalConfiguration configuration, String path, DeployableType deployableType) {
        Deployable deployable = new DefaultDeployableFactory().createDeployable(this.configurationName, path, deployableType);
        configuration.addDeployable(deployable);
    }

    @Required
    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    private String getContainerDirectory(String dir) {
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(this.containerHome);
        fullPath.append(dir);
        String path = fullPath.toString();
        File directory = new File(path);
        if (!directory.exists()) {
            String msg = dir + " directory does not excist! : " + path;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)msg);
            }
            throw new ConfigurationException(msg);
        }
        return path;
    }

    @Override
    public String getSharedLibDirectory() {
        return this.getContainerDirectory("lib/");
    }

    @Override
    public String getConfDirectory() {
        return this.getContainerDirectory("conf/");
    }
}

