/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest.configuration;

import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;
import nl.tranquilizedquality.itest.configuration.DatasourceConfiguration;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.orm.hibernate4.HibernateTransactionManager;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;

@Configuration
@PropertySource(value={"classpath:itest-db.properties"})
public class CommonHibernateDBConfiguration
extends DatasourceConfiguration {
    private Class<?>[] annotatedClasses;
    @Value(value="${hibernate.dialect}")
    private String hibernateDialect;
    @Value(value="${hibernate.show_sql}")
    private String hibernateShowSQL;
    @Value(value="${hibernate.generate_statistics}")
    private String hibernateGenerateStatistics;
    @Value(value="${hibernate.hbm2ddl.auto}")
    private String hibernateHbm2ddl;

    @Bean(name={"transactionManager"})
    public HibernateTransactionManager hibernateTransactionManager(SessionFactory sessionFactory) {
        return new HibernateTransactionManager(sessionFactory);
    }

    @Lazy
    @Bean(name={"sessionFactory"})
    public SessionFactory sessionFactory(DataSource datasource) throws IOException {
        LocalSessionFactoryBean localSessionFactoryBean = new LocalSessionFactoryBean();
        localSessionFactoryBean.setDataSource(datasource);
        localSessionFactoryBean.setAnnotatedClasses((Class[])this.annotatedClasses);
        Properties hibernateProperties = new Properties();
        hibernateProperties.setProperty("hibernate.dialect", this.hibernateDialect);
        hibernateProperties.setProperty("hibernate.show_sql", this.hibernateShowSQL);
        hibernateProperties.setProperty("hibernate.generate_statistics", this.hibernateGenerateStatistics);
        hibernateProperties.setProperty("hibernate.hbm2ddl.auto", this.hibernateHbm2ddl);
        localSessionFactoryBean.setHibernateProperties(hibernateProperties);
        localSessionFactoryBean.afterPropertiesSet();
        return localSessionFactoryBean.getObject();
    }
}

