/*
 * Decompiled with CFR 0.152.
 */
package nl.tranquilizedquality.itest.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

@Configuration
@PropertySource(value={"classpath:itest-db.properties"})
public class DatasourceConfiguration {
    @Value(value="${jdbc.driverClassName}")
    private String driverClassName;
    @Value(value="${jdbc.url}")
    private String url;
    @Value(value="${jdbc.username}")
    private String username;
    @Value(value="${jdbc.password}")
    private String password;

    @Bean(name={"dataSource"})
    public SingleConnectionDataSource singleConnectionDataSource() {
        SingleConnectionDataSource singleConnectionDataSource = new SingleConnectionDataSource();
        singleConnectionDataSource.setDriverClassName(this.driverClassName);
        singleConnectionDataSource.setUrl(this.url);
        singleConnectionDataSource.setUsername(this.username);
        singleConnectionDataSource.setPassword(this.password);
        singleConnectionDataSource.setSuppressClose(true);
        return singleConnectionDataSource;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }
}

