/*
 * Decompiled with CFR 0.152.
 */
package nl.yannickl88.language;

import java.util.HashMap;
import java.util.HashSet;
import nl.yannickl88.language.Classifier;
import nl.yannickl88.language.EntityMatchable;
import nl.yannickl88.language.IntentBuilder;
import nl.yannickl88.language.IntentMatcherLoadable;
import nl.yannickl88.language.LanguageProcessable;
import nl.yannickl88.language.intent.Intent;
import nl.yannickl88.language.matcher.EntityMatch;

public class LanguageProcessor
implements LanguageProcessable,
IntentMatcherLoadable {
    private HashMap<String, Classifier> classifiers = new HashMap();
    private HashSet<String> uniqueWords = new HashSet();
    private int totalUtterances;

    @Override
    public Intent getIntent(String message) {
        double score = 0.0;
        Intent best = new Intent("None");
        for (String key : this.classifiers.keySet()) {
            IntentBuilder builder = new IntentBuilder();
            builder.setAction(key);
            Classifier classifier = this.classifiers.get(key);
            double total = (double)(classifier.getTotalUtterances() + 1) / (double)(this.totalUtterances + 1);
            for (String word : Classifier.getWords(message)) {
                total *= (double)(classifier.getWordCount(word) + 1) / (double)(classifier.getTotalWords() + this.uniqueWords.size());
            }
            if (!(total > score)) continue;
            score = total;
            for (EntityMatchable matcher : classifier.getMatchers()) {
                EntityMatch match = matcher.match(message);
                if (!(match.score > 0.0f) || !match.hasEntity()) continue;
                builder.addEntity(match.getEntityType(), match.getEntity());
            }
            best = builder.createIntent();
        }
        return best;
    }

    @Override
    public void addIntentMatcher(Classifier classifier) {
        this.classifiers.put(classifier.action, classifier);
        this.totalUtterances += classifier.getTotalUtterances();
        this.uniqueWords.addAll(classifier.getWords());
    }
}

