/*
 * Decompiled with CFR 0.152.
 */
package nl.zerofiftyit.mdepunit.core.parse;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.zerofiftyit.mdepunit.model.PomElement;

public final class PomReader {
    private final Map<String, Object> pomData;

    public PomReader(String filePath) throws IOException {
        XmlMapper xmlMapper = new XmlMapper();
        this.pomData = (Map)xmlMapper.readValue(new File(filePath), Map.class);
    }

    public List<PomElement> getAllElements() {
        ArrayList<PomElement> elements = new ArrayList<PomElement>();
        this.traverseMap("", this.pomData, elements);
        return elements;
    }

    private void traverseMap(String path, Object value, List<PomElement> elements) {
        if (value instanceof Map) {
            Map map = (Map)value;
            map.forEach((key, val) -> {
                String newPath = path.isEmpty() ? key : path + "." + key;
                elements.add(new PomElement(newPath, val));
                this.traverseMap(newPath, val, elements);
            });
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                String newPath = path + "[" + i + "]";
                elements.add(new PomElement(newPath, list.get(i)));
                this.traverseMap(newPath, list.get(i), elements);
            }
        }
    }
}

