/*
 * Decompiled with CFR 0.152.
 */
package nl.zerofiftyit.mdepunit.core.validation;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import nl.zerofiftyit.mdepunit.api.DefaultAnalyzer;
import nl.zerofiftyit.mdepunit.core.validation.ResultCaller;
import nl.zerofiftyit.mdepunit.dsl.Statement;
import nl.zerofiftyit.mdepunit.model.NegateNext;
import nl.zerofiftyit.mdepunit.model.PomElement;

public class DefaultAnalyzerImpl
implements DefaultAnalyzer {
    private final String givenNode;
    private List<PomElement> pomElements;
    private final List<PomElement> originalPomElements;
    private final ResultCaller resultCaller;
    private final NegateNext negateNext;
    private final List<String> errorMessages;

    public DefaultAnalyzerImpl(String givenNode, List<PomElement> pomElements, ResultCaller resultCaller, NegateNext negateNext, List<String> errorMessages) {
        this.givenNode = givenNode;
        this.pomElements = pomElements;
        this.originalPomElements = pomElements;
        this.resultCaller = resultCaller;
        this.negateNext = negateNext;
        this.errorMessages = errorMessages;
    }

    public Statement<DefaultAnalyzerImpl> haveTag(@NonNull String tagName) {
        boolean expectationMismatch;
        if (tagName == null) {
            throw new NullPointerException("tagName is marked non-null but is null");
        }
        List<PomElement> elements = this.originalPomElements.stream().filter(element -> element.getPath().startsWith(this.givenNode)).filter(element -> element.getPath().endsWith(tagName)).collect(Collectors.toList());
        boolean hasTag = !elements.isEmpty();
        boolean bl = expectationMismatch = this.negateNext.isNegateNext() == hasTag;
        if (expectationMismatch) {
            if (this.negateNext.isNegateNext()) {
                this.errorMessages.add(String.format("%s found in %s where it is not allowed. \nFound disallowed value: ", tagName, this.givenNode));
                elements.forEach(element -> this.errorMessages.add("- " + element.getValue().toString()));
            } else {
                this.errorMessages.add(String.format("No %s found in %s where it is required", tagName, this.givenNode));
            }
        }
        this.resultCaller.checkForErrors();
        this.pomElements = elements;
        return new Statement<DefaultAnalyzerImpl>(this, this.resultCaller, this.negateNext);
    }

    public Statement<DefaultAnalyzerImpl> containValue(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.filterValue(element -> {
            Object elementValue = element.getValue();
            return elementValue != null && elementValue.toString().contains(value);
        }, value);
    }

    public final Statement<DefaultAnalyzerImpl> equalsValue(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.filterValue(element -> {
            Object elementValue = element.getValue();
            return elementValue != null && elementValue.toString().equals(value);
        }, value);
    }

    private Statement<DefaultAnalyzerImpl> filterValue(Predicate<PomElement> valuePredicate, String value) {
        boolean expectationMismatch;
        List elements = this.originalPomElements.stream().filter(element -> element.getPath().startsWith(this.givenNode)).filter(valuePredicate).collect(Collectors.toList());
        boolean containsValue = !elements.isEmpty();
        boolean bl = expectationMismatch = this.negateNext.isNegateNext() == containsValue;
        if (expectationMismatch) {
            String template = this.negateNext.isNegateNext() ? "Value '%s' found in %s where it is not allowed" : "Value '%s' not found in %s where it is required";
            this.errorMessages.add(String.format(template, value, this.givenNode));
        }
        this.resultCaller.checkForErrors();
        this.pomElements = elements;
        return new Statement<DefaultAnalyzerImpl>(this, this.resultCaller, this.negateNext);
    }

    protected final List<PomElement> getPomElements() {
        return this.pomElements;
    }
}

