/*
 * Decompiled with CFR 0.152.
 */
package nl.zerofiftyit.mdepunit.core.validation;

import java.io.File;
import java.util.List;
import lombok.NonNull;
import nl.zerofiftyit.mdepunit.core.validation.DefaultAnalyzerImpl;
import nl.zerofiftyit.mdepunit.core.validation.ResultCaller;
import nl.zerofiftyit.mdepunit.dsl.Statement;
import nl.zerofiftyit.mdepunit.model.NegateNext;
import nl.zerofiftyit.mdepunit.model.PomElement;

public final class ModuleAnalyzer
extends DefaultAnalyzerImpl {
    private List<PomElement> pomElements;
    private final ResultCaller resultCaller;
    private final NegateNext negateNext;
    private final List<String> errorMessages;

    public ModuleAnalyzer(String givenNode, List<PomElement> pomElements, ResultCaller resultCaller, NegateNext negateNext, List<String> errorMessages) {
        super(givenNode, pomElements, resultCaller, negateNext, errorMessages);
        this.pomElements = pomElements;
        this.resultCaller = resultCaller;
        this.negateNext = negateNext;
        this.errorMessages = errorMessages;
    }

    public Statement<ModuleAnalyzer> moduleExists(@NonNull String moduleName) {
        boolean expectationMismatch;
        if (moduleName == null) {
            throw new NullPointerException("moduleName is marked non-null but is null");
        }
        boolean moduleFound = new File(moduleName).isDirectory() || new File(moduleName + "/pom.xml").exists();
        boolean bl = expectationMismatch = this.negateNext.isNegateNext() == moduleFound;
        if (expectationMismatch) {
            String template = this.negateNext.isNegateNext() ? "Module '%s' directory or pom file found, but not expected" : "Module '%s' directory or pom file not found while expected";
            this.errorMessages.add(String.format(template, moduleName));
        }
        this.resultCaller.checkForErrors();
        return new Statement<ModuleAnalyzer>(this, this.resultCaller, this.negateNext);
    }

    public Statement<ModuleAnalyzer> allRegisteredModulesExist() {
        this.pomElements.stream().filter(element -> element.getPath().equals("module")).map(PomElement::getValue).map(Object::toString).forEach(this::moduleExists);
        this.resultCaller.checkForErrors();
        return new Statement<ModuleAnalyzer>(this, this.resultCaller, this.negateNext);
    }

    public Statement<ModuleAnalyzer> containModuleNode(@NonNull String moduleName) {
        if (moduleName == null) {
            throw new NullPointerException("moduleName is marked non-null but is null");
        }
        super.containValue(moduleName);
        this.pomElements = super.getPomElements();
        return new Statement<ModuleAnalyzer>(this, this.resultCaller, this.negateNext);
    }
}

