/*
 * Decompiled with CFR 0.152.
 */
package nl.zerofiftyit.mdepunit.core.validation;

import java.util.List;
import java.util.stream.Collectors;
import nl.zerofiftyit.mdepunit.core.validation.DefaultAnalyzerImpl;
import nl.zerofiftyit.mdepunit.core.validation.ResultCaller;
import nl.zerofiftyit.mdepunit.dsl.Statement;
import nl.zerofiftyit.mdepunit.model.NegateNext;
import nl.zerofiftyit.mdepunit.model.PomElement;

public final class PomAnalyzer
extends DefaultAnalyzerImpl {
    private List<PomElement> pomElements;
    private final ResultCaller resultCaller;
    private final NegateNext negateNext;
    private final List<String> errorMessages;

    public PomAnalyzer(String givenNode, List<PomElement> pomElements, ResultCaller resultCaller, NegateNext negateNext, List<String> errorMessages) {
        super(givenNode, pomElements, resultCaller, negateNext, errorMessages);
        this.pomElements = pomElements;
        this.resultCaller = resultCaller;
        this.negateNext = negateNext;
        this.errorMessages = errorMessages;
    }

    public Statement<PomAnalyzer> haveProperty(String propertyName) {
        boolean expectationMismatch;
        List properties = this.pomElements.stream().filter(element -> element.getPath().startsWith("properties")).filter(element -> element.getPath().contains(propertyName)).collect(Collectors.toList());
        boolean hasProperty = !properties.isEmpty();
        boolean bl = expectationMismatch = this.negateNext.isNegateNext() == hasProperty;
        if (expectationMismatch) {
            String template = this.negateNext.isNegateNext() ? "Property '%s' found where not allowed" : "Required property '%s' not found";
            this.errorMessages.add(String.format(template, propertyName));
        }
        this.resultCaller.checkForErrors();
        this.pomElements = properties;
        return new Statement<PomAnalyzer>(this, this.resultCaller, this.negateNext);
    }
}

