/*
 * Decompiled with CFR 0.152.
 */
package nl.zerofiftyit.mdepunit.core.validation;

import java.util.List;
import lombok.NonNull;
import nl.zerofiftyit.mdepunit.exception.PomValidationException;

public final class ResultCaller {
    private final List<String> errorMessages;
    private final StringBuilder stringBuilder;
    private boolean hasErrors;

    public ResultCaller(List<String> errorMessages) {
        this.errorMessages = errorMessages;
        this.stringBuilder = new StringBuilder();
    }

    public void validate() {
        if (this.hasErrors) {
            throw new PomValidationException(this.stringBuilder.toString());
        }
    }

    public void validate(@NonNull String reason) {
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        this.stringBuilder.insert(0, reason + "\n");
        this.validate();
    }

    public void checkForErrors() {
        if (!this.errorMessages.isEmpty()) {
            this.hasErrors = true;
            this.stringBuilder.append("Error(s) occurred:\n");
            this.errorMessages.stream().map(errorMessage -> errorMessage + "\n").forEach(this.stringBuilder::append);
            this.errorMessages.clear();
        }
    }

    public void clearErrors() {
        this.errorMessages.clear();
        this.stringBuilder.setLength(0);
        this.hasErrors = false;
    }
}

