/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import no.acntech.common.test.Type;

interface BasicType
extends Type {
    public boolean isType(Class<?> var1);

    public static List<BasicType> getBasicTypes() {
        ArrayList<BasicType> basicTypes = new ArrayList<BasicType>();
        basicTypes.add(new BasicType(){

            @Override
            public boolean isType(Class<?> clazz) {
                return String.class.isAssignableFrom(clazz);
            }

            @Override
            public Object getType(Class<?> clazz) {
                return "whatever";
            }
        });
        basicTypes.add(new BasicType(){

            @Override
            public boolean isType(Class<?> clazz) {
                return Boolean.TYPE == clazz || Boolean.class.isAssignableFrom(clazz);
            }

            @Override
            public Object getType(Class<?> clazz) {
                return Boolean.TRUE;
            }
        });
        basicTypes.add(new BasicType(){

            @Override
            public boolean isType(Class<?> clazz) {
                return Integer.TYPE == clazz || Integer.class.isAssignableFrom(clazz);
            }

            @Override
            public Object getType(Class<?> clazz) {
                return 1337;
            }
        });
        basicTypes.add(new BasicType(){

            @Override
            public boolean isType(Class<?> clazz) {
                return Long.TYPE == clazz || Long.class.isAssignableFrom(clazz);
            }

            @Override
            public Object getType(Class<?> clazz) {
                return 1337L;
            }
        });
        basicTypes.add(new BasicType(){

            @Override
            public boolean isType(Class<?> clazz) {
                return Double.TYPE == clazz || Double.class.isAssignableFrom(clazz);
            }

            @Override
            public Object getType(Class<?> clazz) {
                return 13.37;
            }
        });
        basicTypes.add(new BasicType(){

            @Override
            public boolean isType(Class<?> clazz) {
                return Float.TYPE == clazz || Float.class.isAssignableFrom(clazz);
            }

            @Override
            public Object getType(Class<?> clazz) {
                return Float.valueOf(13.37f);
            }
        });
        basicTypes.add(new BasicType(){

            @Override
            public boolean isType(Class<?> clazz) {
                return Character.TYPE == clazz || Character.class.isAssignableFrom(clazz);
            }

            @Override
            public Object getType(Class<?> clazz) {
                return Character.valueOf('Y');
            }
        });
        basicTypes.add(new BasicType(){

            @Override
            public boolean isType(Class<?> clazz) {
                return List.class.isAssignableFrom(clazz);
            }

            @Override
            public Object getType(Class<?> clazz) {
                return new ArrayList();
            }
        });
        basicTypes.add(new BasicType(){

            @Override
            public boolean isType(Class<?> clazz) {
                return clazz.isArray();
            }

            @Override
            public Object getType(Class<?> clazz) {
                return Array.newInstance(clazz.getComponentType(), 1);
            }
        });
        return basicTypes;
    }
}

