/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import no.acntech.common.test.BasicType;
import no.acntech.common.test.GetterSetter;
import no.acntech.common.test.TestReflectionUtils;
import org.junit.Assert;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaBeanTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaBeanTester.class);

    private JavaBeanTester() {
    }

    public static <T> void test(Class<T> ... classes) throws IntrospectionException {
        if (classes == null) {
            throw new IllegalArgumentException("Input classes is null");
        }
        for (Class<T> clazz : classes) {
            JavaBeanTester.test(clazz);
        }
    }

    public static <T> void test(Class<T> clazz) throws IntrospectionException {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        JavaBeanTester.test(clazz, new String[0]);
    }

    public static <T> void test(Class<T> clazz, String ... skipTheseFields) throws IntrospectionException {
        List<GetterSetter> gettersAndSetters = TestReflectionUtils.findGettersAndSetters(clazz, skipTheseFields);
        for (GetterSetter getterSetter : gettersAndSetters) {
            PropertyDescriptor descriptor = getterSetter.getDescriptor();
            Method getter = getterSetter.getGetter();
            Method setter = getterSetter.getSetter();
            try {
                Object expectedType = JavaBeanTester.createType(getter.getReturnType());
                T bean = TestReflectionUtils.createBean(clazz, new Object[0]);
                setter.invoke(bean, expectedType);
                Object actualType = getter.invoke(bean, new Object[0]);
                Assert.assertEquals((String)String.format("Failed when testing types %s", descriptor.getName()), (Object)expectedType, (Object)actualType);
            }
            catch (Exception e) {
                String error = String.format("An exception was thrown during bean no.acntech.common.no.acntech.common.test %s", descriptor.getName());
                LOGGER.error(error, (Throwable)e);
                Assert.fail((String)String.format("%s: %s", error, e.toString()));
            }
        }
    }

    private static Object createType(Class<?> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, DatatypeConfigurationException {
        Object object = JavaBeanTester.createBasicType(clazz);
        if (object != null) {
            return object;
        }
        object = JavaBeanTester.createObjectType(clazz);
        if (object != null) {
            return object;
        }
        object = JavaBeanTester.createMockType(clazz);
        if (object != null) {
            return object;
        }
        Assert.fail((String)String.format("Could not create bean object of class %s, please extend the %s class to prevent this.", clazz.getName(), JavaBeanTester.class.getName()));
        return null;
    }

    private static <T> Object createBasicType(Class<T> clazz) {
        List<BasicType> basicTypes = BasicType.getBasicTypes();
        for (BasicType basicType : basicTypes) {
            if (!basicType.isType(clazz)) continue;
            return basicType.getType(clazz);
        }
        return null;
    }

    private static Object createObjectType(Class<?> clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor.newInstance(new Object[0]);
        }
        return null;
    }

    private static Object createMockType(Class<?> clazz) {
        if (!Modifier.isFinal(clazz.getModifiers())) {
            return Mockito.mock(clazz);
        }
        return null;
    }
}

