/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import no.acntech.common.test.GetterSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestReflectionUtils.class);

    private TestReflectionUtils() {
    }

    public static void setPrivateField(Object target, String fieldName, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        if (target == null) {
            throw new IllegalArgumentException("Target object is null");
        }
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(Boolean.TRUE);
        field.set(target, value);
    }

    public static void invokePrivateMethod(Object target, String methodName, Object ... args) throws IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (target == null) {
            throw new IllegalArgumentException("Target object is null");
        }
        Method method = target.getClass().getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(Boolean.TRUE);
        method.invoke(target, args);
    }

    static <T> T createBean(Class<T> clazz, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Constructor<?> constructor = TestReflectionUtils.getConstructor(clazz);
        return TestReflectionUtils.createBean(constructor, args);
    }

    static <T> T createBean(Constructor<?> constructor, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (constructor == null) {
            throw new IllegalArgumentException("Constructor is null");
        }
        if (args != null) {
            return (T)constructor.newInstance(args);
        }
        int minParams = constructor.getParameterTypes().length;
        if (minParams == 0) {
            return (T)constructor.newInstance(new Object[0]);
        }
        return (T)constructor.newInstance(new Object[minParams]);
    }

    static Constructor<?>[] getConstructors(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        return constructors.length > 0 ? constructors : clazz.getDeclaredConstructors();
    }

    static Constructor<?> getConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = TestReflectionUtils.getConstructors(clazz);
        if (constructors == null || constructors.length == 0) {
            return null;
        }
        int minParams = Integer.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < constructors.length; ++i) {
            int params = constructors[i].getParameterTypes().length;
            if (params >= minParams) continue;
            minParams = params;
            index = i;
        }
        return constructors[index];
    }

    static <T> List<GetterSetter> findGettersAndSetters(Class<T> clazz, String ... skipThese) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        HashSet<String> skipFields = new HashSet<String>(Arrays.asList(skipThese));
        ArrayList<GetterSetter> gettersAndSetters = new ArrayList<GetterSetter>();
        for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            if (skipFields.contains(descriptor.getName())) {
                LOGGER.info("Skipping field {} as ordered", (Object)descriptor.getName());
                continue;
            }
            TestReflectionUtils.findBooleanGetters(clazz, descriptor);
            Method getter = descriptor.getReadMethod();
            Method setter = descriptor.getWriteMethod();
            if (getter != null && setter != null) {
                Class<?> returnType = getter.getReturnType();
                Class<?>[] params = setter.getParameterTypes();
                if (params.length == 1 && params[0] == returnType) {
                    gettersAndSetters.add(new GetterSetter(descriptor, getter, setter));
                    continue;
                }
                LOGGER.debug("Getter and setter for field {} has non matching type", (Object)descriptor.getName());
                continue;
            }
            LOGGER.debug("Getter or setter missing for field {}", (Object)descriptor.getName());
        }
        return gettersAndSetters;
    }

    private static <T> void findBooleanGetters(Class<T> clazz, PropertyDescriptor descriptor) throws IntrospectionException {
        if (descriptor.getReadMethod() == null && descriptor.getPropertyType() == Boolean.class) {
            LOGGER.debug("Getter for field {} is boolean", (Object)descriptor.getName());
            try {
                PropertyDescriptor pd = new PropertyDescriptor(descriptor.getName(), clazz);
                descriptor.setReadMethod(pd.getReadMethod());
            }
            catch (IntrospectionException e) {
                LOGGER.debug("Error while finding boolean getter", (Throwable)e);
            }
        } else {
            LOGGER.trace("Getter for field {} is non boolean", (Object)descriptor.getName());
        }
    }
}

