/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ClassCriteria {
    public static final int DEFAULT_MAX_CLASS_LIMIT = 100;
    private int maxClassLimit;
    private boolean recursiveSearch;
    private boolean excludeInterfaces;
    private boolean excludeEnums;
    private boolean excludeAnnotations;
    private boolean excludeMemberClasses;
    private Set<String> excludePathRegex;

    private ClassCriteria() {
    }

    public int getMaxClassLimit() {
        return this.maxClassLimit;
    }

    public boolean isRecursiveSearch() {
        return this.recursiveSearch;
    }

    public boolean isExcludeInterfaces() {
        return this.excludeInterfaces;
    }

    public boolean isExcludeEnums() {
        return this.excludeEnums;
    }

    public boolean isExcludeAnnotations() {
        return this.excludeAnnotations;
    }

    public boolean isExcludeMemberClasses() {
        return this.excludeMemberClasses;
    }

    public Set<String> getExcludePathRegex() {
        if (this.excludePathRegex == null) {
            this.excludePathRegex = new HashSet<String>();
        }
        return this.excludePathRegex;
    }

    public static Builder createDefault() {
        return new Builder(new ClassCriteria()).doNonRecursiveSearch().doIncludeAll().withMaxClassLimit(100);
    }

    public static Builder createRecursive() {
        return new Builder(new ClassCriteria()).doRecursiveSearch().doIncludeAll().withMaxClassLimit(100);
    }

    public static class Builder {
        private ClassCriteria classCriteria;

        private Builder(ClassCriteria classCriteria) {
            if (classCriteria == null) {
                throw new IllegalArgumentException("Class criteria is null");
            }
            this.classCriteria = classCriteria;
        }

        public Builder withMaxClassLimit(int maxClassLimit) {
            this.classCriteria.maxClassLimit = maxClassLimit;
            return this;
        }

        public Builder doRecursiveSearch() {
            this.classCriteria.recursiveSearch = Boolean.TRUE;
            return this;
        }

        public Builder doExcludeInterfaces() {
            this.classCriteria.excludeInterfaces = Boolean.TRUE;
            return this;
        }

        public Builder doExcludeEnums() {
            this.classCriteria.excludeEnums = Boolean.TRUE;
            return this;
        }

        public Builder doExcludeAnnotations() {
            this.classCriteria.excludeAnnotations = Boolean.TRUE;
            return this;
        }

        public Builder doExcludeMemberClasses() {
            this.classCriteria.excludeMemberClasses = Boolean.TRUE;
            return this;
        }

        public Builder doExcludePaths(String ... pathRegexes) {
            if (this.classCriteria.excludePathRegex == null) {
                this.classCriteria.excludePathRegex = new HashSet();
            }
            if (pathRegexes != null) {
                this.classCriteria.excludePathRegex.addAll(Arrays.asList(pathRegexes));
            }
            return this;
        }

        public Builder doNonRecursiveSearch() {
            this.classCriteria.recursiveSearch = Boolean.FALSE;
            return this;
        }

        public Builder doIncludeInterfaces() {
            this.classCriteria.excludeInterfaces = Boolean.FALSE;
            return this;
        }

        public Builder doIncludeEnums() {
            this.classCriteria.excludeEnums = Boolean.FALSE;
            return this;
        }

        public Builder doIncludeAnnotations() {
            this.classCriteria.excludeAnnotations = Boolean.FALSE;
            return this;
        }

        public Builder doIncludeMemberClasses() {
            this.classCriteria.excludeMemberClasses = Boolean.FALSE;
            return this;
        }

        public Builder doExcludeAll() {
            this.classCriteria.excludeInterfaces = Boolean.TRUE;
            this.classCriteria.excludeEnums = Boolean.TRUE;
            this.classCriteria.excludeAnnotations = Boolean.TRUE;
            this.classCriteria.excludeMemberClasses = Boolean.TRUE;
            return this;
        }

        public Builder doIncludeAll() {
            this.classCriteria.excludeInterfaces = Boolean.FALSE;
            this.classCriteria.excludeEnums = Boolean.FALSE;
            this.classCriteria.excludeAnnotations = Boolean.FALSE;
            this.classCriteria.excludeMemberClasses = Boolean.FALSE;
            return this;
        }

        public ClassCriteria build() {
            return this.classCriteria;
        }
    }
}

