/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import no.acntech.common.test.TestReflectionUtils;
import no.acntech.common.test.TestTypeFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExceptionTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionTester.class);

    private ExceptionTester() {
    }

    @Deprecated
    public static void test(Class<? extends Throwable> ... throwables) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ExceptionTester.testExceptions(throwables);
    }

    @SafeVarargs
    public static void testExceptions(Class<? extends Throwable> ... throwables) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (throwables == null) {
            throw new IllegalArgumentException("Input throwables array is null");
        }
        for (Class<? extends Throwable> throwable : throwables) {
            ExceptionTester.testException(throwable);
        }
    }

    public static void testException(Class<? extends Throwable> throwable) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (throwable == null) {
            throw new IllegalArgumentException("Input is null");
        }
        ExceptionTester.testExceptionWithArgs(throwable, new Object[0]);
        ExceptionTester.testExceptionWithArgs(throwable, "Exception message");
        ExceptionTester.testExceptionWithArgs(throwable, new Throwable("Exception cause"));
        ExceptionTester.testExceptionWithArgs(throwable, "Exception message", new Throwable("Exception cause"));
    }

    public static void testExceptionWithArgs(Class<? extends Throwable> throwable, Object ... args) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (throwable == null) {
            throw new IllegalArgumentException("Input throwable is null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Input args array is null");
        }
        Class<?>[] params = TestTypeFactory.getClassesForObjects(args);
        Constructor<? extends Throwable> constructor = TestReflectionUtils.findConstructorWithAllParamsMatch(throwable, params);
        ExceptionTester.testException(constructor, throwable, args);
    }

    private static void testException(Constructor<? extends Throwable> constructor, Class<? extends Throwable> throwable, Object ... args) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (constructor != null) {
            Throwable t = TestReflectionUtils.createBean(constructor, args);
            try {
                ExceptionTester.throwException(t);
                Assert.fail((String)"Exception was not thrown");
            }
            catch (Throwable e) {
                MatcherAssert.assertThat((String)"Exception is not of expected type", (Object)e, (Matcher)CoreMatchers.instanceOf(throwable));
                LOGGER.debug("Exception message: {}", (Object)e.getMessage());
                LOGGER.debug("Exception localized message: {}", (Object)e.getLocalizedMessage());
                Throwable cause = e.getCause();
                LOGGER.debug("Exception cause: {}", (Object)(cause == null ? "N/A" : cause.getClass().getName()));
            }
        } else {
            LOGGER.warn("Constructor is null");
        }
    }

    private static void throwException(Throwable t) throws Throwable {
        throw t;
    }
}

