/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import no.acntech.common.test.ClassCriteria;
import no.acntech.common.test.FieldCriteria;
import no.acntech.common.test.Getter;
import no.acntech.common.test.GetterSetter;
import no.acntech.common.test.ObjectInstantiationException;
import no.acntech.common.test.TestReflectionUtils;
import no.acntech.common.test.TestTypeFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaBeanTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaBeanTester.class);
    private static final String GENERAL_EXCEPTION_MESSAGE_FORMAT = "An exception was thrown during test of field %s on bean of type %s";
    private static final String OBJECT_INSTANTIATION_EXCEPTION_MESSAGE_FORMAT = "Could not create object for class %s. Add custom types by using TestTypeFactory.addBasicType(BasicType basicType)";

    private JavaBeanTester() {
    }

    @Deprecated
    public static void test(Class<?> ... classes) throws IntrospectionException {
        JavaBeanTester.testClasses(classes);
    }

    @Deprecated
    public static void test(Class<?> clazz) throws IntrospectionException {
        JavaBeanTester.testClass(clazz);
    }

    @Deprecated
    public static void test(Class<?> clazz, String ... skipTheseFields) throws IntrospectionException {
        JavaBeanTester.testClass(clazz, skipTheseFields);
    }

    public static void testClasses(Class<?> ... classes) throws IntrospectionException {
        if (classes == null) {
            throw new IllegalArgumentException("Input classes is null");
        }
        for (Class<?> clazz : classes) {
            JavaBeanTester.testClass(clazz);
        }
    }

    public static void testClass(Class<?> clazz) throws IntrospectionException {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        JavaBeanTester.testClass(clazz, new String[0]);
    }

    public static void testClass(Class<?> clazz, String ... skipTheseFields) throws IntrospectionException {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        if (skipTheseFields == null) {
            throw new IllegalArgumentException("Skip fields array is null");
        }
        JavaBeanTester.testClass(clazz, FieldCriteria.createDefault().doExcludeFields(skipTheseFields).build());
    }

    public static void testClass(Class<?> clazz, FieldCriteria fieldCriteria) throws IntrospectionException {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        if (fieldCriteria == null) {
            throw new IllegalArgumentException("Field criteria is null");
        }
        List<GetterSetter> gettersAndSetters = TestReflectionUtils.findGettersAndSetters(clazz, fieldCriteria);
        for (GetterSetter getterSetter : gettersAndSetters) {
            JavaBeanTester.testSetterAndGetter(clazz, getterSetter);
        }
        List<Getter> getters = TestReflectionUtils.findGetters(clazz, fieldCriteria);
        for (Getter getter : getters) {
            JavaBeanTester.testConstructorAndGetter(clazz, getter);
        }
    }

    public static void testClasses(Package pkg) throws IOException, ClassNotFoundException, IntrospectionException {
        JavaBeanTester.testClasses(pkg, ClassCriteria.createDefault().build());
    }

    public static void testClasses(Package pkg, ClassCriteria classCriteria) throws IOException, ClassNotFoundException, IntrospectionException {
        Class<?>[] classes = TestReflectionUtils.findClasses(pkg, classCriteria);
        JavaBeanTester.testClasses(classes);
    }

    private static void testSetterAndGetter(Class<?> clazz, GetterSetter getterSetter) {
        PropertyDescriptor descriptor = getterSetter.getDescriptor();
        Method getterMethod = getterSetter.getGetter();
        Method setterMethod = getterSetter.getSetter();
        try {
            Object expectedType = TestTypeFactory.createType(getterMethod.getReturnType());
            Object bean = TestReflectionUtils.createBean(clazz, new Object[0]);
            setterMethod.invoke(bean, expectedType);
            Object actualType = getterMethod.invoke(bean, new Object[0]);
            Assert.assertThat((String)("Failed when testing field " + descriptor.getName()), expectedType, (Matcher)CoreMatchers.is((Object)actualType));
        }
        catch (ObjectInstantiationException e) {
            String error = String.format(OBJECT_INSTANTIATION_EXCEPTION_MESSAGE_FORMAT, clazz.getName());
            LOGGER.error(error, (Throwable)e);
            Assert.fail((String)error);
        }
        catch (Exception e) {
            String error = String.format(GENERAL_EXCEPTION_MESSAGE_FORMAT, descriptor.getName(), clazz.getName());
            LOGGER.error(error, (Throwable)e);
            Assert.fail((String)String.format("%s: %s", error, e.toString()));
        }
    }

    private static void testConstructorAndGetter(Class<?> clazz, Getter getter) {
        PropertyDescriptor descriptor = getter.getDescriptor();
        Method getterMethod = getter.getGetter();
        try {
            Constructor<?>[] constructors;
            Object expectedType = TestTypeFactory.createType(getterMethod.getReturnType());
            for (Constructor<?> constructor : constructors = TestReflectionUtils.findConstructorsWithParamMatch(clazz, getterMethod.getReturnType())) {
                JavaBeanTester.testConstructorAndGetter(constructor, getter, expectedType);
            }
        }
        catch (ObjectInstantiationException e) {
            String error = String.format(OBJECT_INSTANTIATION_EXCEPTION_MESSAGE_FORMAT, clazz.getName());
            LOGGER.error(error, (Throwable)e);
            Assert.fail((String)error);
        }
        catch (Exception e) {
            LOGGER.trace(String.format(GENERAL_EXCEPTION_MESSAGE_FORMAT, descriptor.getName(), clazz.getName()), (Throwable)e);
        }
    }

    private static void testConstructorAndGetter(Constructor<?> constructor, Getter getter, Object expectedType) {
        PropertyDescriptor descriptor = getter.getDescriptor();
        Method getterMethod = getter.getGetter();
        Class<?>[] params = constructor.getParameterTypes();
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            args[i] = params[i].isAssignableFrom(getterMethod.getReturnType()) ? expectedType : null;
        }
        try {
            Object bean = TestReflectionUtils.createBean(constructor, args);
            Object actualType = getterMethod.invoke(bean, new Object[0]);
            if (actualType != expectedType) {
                LOGGER.warn("Constructor did not set same class field as used for getter");
            }
        }
        catch (Exception e) {
            LOGGER.trace(String.format(GENERAL_EXCEPTION_MESSAGE_FORMAT, descriptor.getName(), constructor.getDeclaringClass().getName()), (Throwable)e);
        }
    }
}

