/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.acntech.common.test.ClassCriteria;
import no.acntech.common.test.ClassloaderNullException;
import no.acntech.common.test.FieldCriteria;
import no.acntech.common.test.Getter;
import no.acntech.common.test.GetterSetter;
import no.acntech.common.test.NoSuchConstructorException;
import no.acntech.common.test.TestTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestReflectionUtils.class);
    private static final char PKG_SEPARATOR = '.';
    private static final char DIR_SEPARATOR = '/';
    private static final String CLASS_FILE_SUFFIX = ".class";

    private TestReflectionUtils() {
    }

    public static void setInternalField(Object target, String fieldName, Object value) throws IllegalAccessException, NoSuchFieldException {
        if (target == null) {
            throw new IllegalArgumentException("Target object is null");
        }
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(Boolean.TRUE);
        field.set(target, value);
    }

    public static Object invokePrivateMethod(Object target, String methodName, Object ... args) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (target == null) {
            throw new IllegalArgumentException("Target object is null");
        }
        Class<?>[] params = TestTypeFactory.getClassesForObjects(args);
        Method method = target.getClass().getDeclaredMethod(methodName, params);
        method.setAccessible(Boolean.TRUE);
        return method.invoke(target, args);
    }

    static boolean isFinalClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class is null");
        }
        return Modifier.isFinal(clazz.getModifiers());
    }

    static boolean isClassExists(Class<?> clazz, ClassLoader classLoader) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class is null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader is null");
        }
        try {
            Class.forName(clazz.getName(), Boolean.FALSE, classLoader);
            return Boolean.TRUE;
        }
        catch (ClassNotFoundException e) {
            return Boolean.FALSE;
        }
    }

    static <T> T createBean(Class<T> clazz, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?>[] params = TestTypeFactory.getClassesForObjects(args);
        Constructor<T> constructor = TestReflectionUtils.findConstructorWithAllParamsMatch(clazz, params);
        return TestReflectionUtils.createBean(constructor, args);
    }

    static <T> T createBean(Constructor<T> constructor, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (constructor == null) {
            throw new IllegalArgumentException("Constructor is null");
        }
        if (args == null || args.length == 0) {
            return constructor.newInstance(new Object[0]);
        }
        return constructor.newInstance(args);
    }

    static <T> Constructor<T> findConstructorWithAllParamsMatch(Class<T> clazz, Class<?> ... wantedParams) {
        Constructor<T>[] constructors = TestReflectionUtils.findAllConstructors(clazz);
        if (constructors != null) {
            for (Constructor<T> constructor : constructors) {
                Class<?>[] actualParams = constructor.getParameterTypes();
                if (!TestReflectionUtils.isAllParamsMatch(actualParams, wantedParams)) continue;
                return constructor;
            }
        }
        throw new NoSuchConstructorException(clazz);
    }

    static <T> Constructor<T>[] findConstructorsWithParamMatch(Class<T> clazz, Class<?> wantedParam) {
        Constructor<T>[] constructors = TestReflectionUtils.findAllConstructors(clazz);
        ArrayList<Constructor<T>> matchedConstructors = new ArrayList<Constructor<T>>();
        if (constructors != null) {
            for (Constructor<T> constructor : constructors) {
                Class<?>[] actualParams = constructor.getParameterTypes();
                if (!TestReflectionUtils.isParamMatch(actualParams, wantedParam)) continue;
                matchedConstructors.add(constructor);
            }
        }
        if (matchedConstructors.isEmpty()) {
            throw new NoSuchConstructorException(clazz);
        }
        return matchedConstructors.toArray(new Constructor[matchedConstructors.size()]);
    }

    private static <T> Constructor<T>[] findAllConstructors(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length > 0) {
            return constructors;
        }
        return clazz.getDeclaredConstructors();
    }

    static Class<?>[] findClasses(Package pkg, ClassCriteria classCriteria) throws IOException, ClassNotFoundException {
        if (pkg == null) {
            throw new IllegalArgumentException("Package is null");
        }
        return TestReflectionUtils.findClasses(pkg.getName(), classCriteria);
    }

    static Class<?>[] findClasses(String packageName, ClassCriteria classCriteria) throws IOException, ClassNotFoundException {
        if (packageName == null) {
            throw new IllegalArgumentException("Package name is null");
        }
        if (classCriteria == null) {
            throw new IllegalArgumentException("Class search criteria is null");
        }
        LOGGER.info("Searching for classes in package {}{}", (Object)packageName, (Object)(classCriteria.isRecursiveSearch() ? " recursively" : ""));
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader == null) {
            throw new ClassloaderNullException(thread);
        }
        String path = packageName.replace('.', '/');
        LOGGER.trace("Converted package {} to path {}", (Object)packageName, (Object)path);
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> files = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String pathName = URLDecoder.decode(resource.getFile(), "UTF-8");
            files.add(new File(pathName));
        }
        ArrayList classes = new ArrayList();
        for (File file : files) {
            classes.addAll(TestReflectionUtils.findClasses(file, packageName, classCriteria, classes));
            if (classes.size() < classCriteria.getMaxClassLimit()) continue;
            LOGGER.info("Number of classes found during package search has reached the max class limit of {}, so stopping search", (Object)classCriteria.getMaxClassLimit());
            break;
        }
        LOGGER.info("Found a total of {} classes in package {}{}", new Object[]{classes.size(), packageName, classCriteria.isRecursiveSearch() ? " and all child packages" : ""});
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class<?>> findClasses(File directory, String packageName, ClassCriteria classCriteria, List<Class<?>> allClasses) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            LOGGER.debug("Directory {} does not exist, so skipping directory", (Object)directory.getAbsolutePath());
            return classes;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            LOGGER.debug("No children found in directory {}, so skipping directory", (Object)directory.getAbsolutePath());
            return classes;
        }
        LOGGER.debug("Searching for classes in package {}\u00a0in directory {}", (Object)packageName, (Object)directory.getAbsolutePath());
        for (File file : files) {
            if (TestReflectionUtils.isPathRegexMatch(classCriteria, file)) continue;
            if (file.isDirectory()) {
                TestReflectionUtils.processDirectory(file, packageName, classCriteria, classes, allClasses);
            } else if (file.isFile()) {
                TestReflectionUtils.processFile(directory, file, packageName, classCriteria, classes);
            } else {
                LOGGER.debug("File {} is not a directory nor a file, so skipping", (Object)file.getName());
            }
            if (allClasses.size() + classes.size() >= classCriteria.getMaxClassLimit()) break;
        }
        LOGGER.debug("Found {} classes in directory {}", (Object)classes.size(), (Object)directory.getAbsolutePath());
        return classes;
    }

    private static void processDirectory(File file, String packageName, ClassCriteria classCriteria, List<Class<?>> allClasses, List<Class<?>> classes) throws ClassNotFoundException {
        if (!classCriteria.isRecursiveSearch()) {
            LOGGER.trace("Non recursive search criteria specified, so skipping directory");
        } else if (file.getName().contains(String.valueOf('.'))) {
            LOGGER.debug("Directory {} contains character {}, so skipping directory", (Object)file.getAbsolutePath(), (Object)Character.valueOf('.'));
        } else {
            String subPackageName = packageName + String.valueOf('.') + file.getName();
            classes.addAll(TestReflectionUtils.findClasses(file, subPackageName, classCriteria, allClasses));
        }
    }

    private static void processFile(File directory, File file, String packageName, ClassCriteria classCriteria, List<Class<?>> classes) throws ClassNotFoundException {
        if (file.getName().endsWith(CLASS_FILE_SUFFIX)) {
            String className = packageName + String.valueOf('.') + file.getName().replace(CLASS_FILE_SUFFIX, "");
            LOGGER.trace("Found class {} in directory {}", (Object)className, (Object)directory.getAbsolutePath());
            Class<?> clazz = Class.forName(className);
            if (clazz.isInterface() && classCriteria.isExcludeInterfaces()) {
                LOGGER.trace("Class search criteria specifies to exclude interfaces, so skipping class {}", (Object)className);
            } else if (clazz.isEnum() && classCriteria.isExcludeEnums()) {
                LOGGER.trace("Class search criteria specifies to exclude enums, so skipping class {}", (Object)className);
            } else if (clazz.isAnnotation() && classCriteria.isExcludeAnnotations()) {
                LOGGER.trace("Class search criteria specifies to exclude annotations, so skipping class {}", (Object)className);
            } else if (clazz.isMemberClass() && classCriteria.isExcludeMemberClasses()) {
                LOGGER.trace("Class search criteria specifies to exclude member classes, so skipping class {}", (Object)className);
            } else {
                classes.add(clazz);
            }
        } else {
            LOGGER.debug("File {} does not have a class file ending {}, so skipping file", (Object)file.getAbsolutePath(), (Object)CLASS_FILE_SUFFIX);
        }
    }

    static <T> List<GetterSetter> findGettersAndSetters(Class<T> clazz) throws IntrospectionException {
        return TestReflectionUtils.findGettersAndSetters(clazz, FieldCriteria.createDefault().build());
    }

    static <T> List<GetterSetter> findGettersAndSetters(Class<T> clazz, FieldCriteria fieldCriteria) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        ArrayList<GetterSetter> gettersAndSetters = new ArrayList<GetterSetter>();
        for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            if (fieldCriteria.getExcludeFields().contains(descriptor.getName())) {
                LOGGER.info("Skipping field {} as ordered", (Object)descriptor.getName());
                continue;
            }
            TestReflectionUtils.findBooleanGetters(clazz, descriptor);
            Method getter = descriptor.getReadMethod();
            Method setter = descriptor.getWriteMethod();
            if (getter != null && setter != null) {
                Class<?> returnType = getter.getReturnType();
                Class<?>[] params = setter.getParameterTypes();
                if (params.length == 1 && params[0] == returnType) {
                    gettersAndSetters.add(new GetterSetter(descriptor, getter, setter));
                    continue;
                }
                LOGGER.debug("Getter and setter for field {} has non matching type", (Object)descriptor.getName());
                continue;
            }
            LOGGER.debug("Getter or setter missing for field {}", (Object)descriptor.getName());
        }
        return gettersAndSetters;
    }

    static <T> List<Getter> findGetters(Class<T> clazz) throws IntrospectionException {
        return TestReflectionUtils.findGetters(clazz, FieldCriteria.createDefault().build());
    }

    static <T> List<Getter> findGetters(Class<T> clazz, FieldCriteria fieldCriteria) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        ArrayList<Getter> getters = new ArrayList<Getter>();
        for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            if (fieldCriteria.getExcludeFields().contains(descriptor.getName())) {
                LOGGER.info("Skipping field {} as ordered", (Object)descriptor.getName());
                continue;
            }
            TestReflectionUtils.findBooleanGetters(clazz, descriptor);
            Method getter = descriptor.getReadMethod();
            if (getter != null) {
                getters.add(new Getter(descriptor, getter));
                continue;
            }
            LOGGER.debug("Getter missing for field {}", (Object)descriptor.getName());
        }
        return getters;
    }

    private static <T> void findBooleanGetters(Class<T> clazz, PropertyDescriptor descriptor) throws IntrospectionException {
        if (descriptor.getReadMethod() == null && Boolean.class.isAssignableFrom(descriptor.getPropertyType())) {
            LOGGER.debug("Getter for field {} is boolean", (Object)descriptor.getName());
            try {
                PropertyDescriptor pd = new PropertyDescriptor(descriptor.getName(), clazz);
                descriptor.setReadMethod(pd.getReadMethod());
            }
            catch (IntrospectionException e) {
                LOGGER.debug("Error while finding boolean getter", (Throwable)e);
            }
        } else {
            LOGGER.trace("Getter for field {} is non boolean", (Object)descriptor.getName());
        }
    }

    private static boolean isAllParamsMatch(Class<?>[] actualParams, Class<?>[] wantedParams) {
        if (actualParams == null || wantedParams == null || actualParams.length != wantedParams.length) {
            return Boolean.FALSE;
        }
        boolean allMatch = Boolean.TRUE;
        for (int i = 0; i < actualParams.length; ++i) {
            allMatch = allMatch && actualParams[i].isAssignableFrom(wantedParams[i]);
        }
        return allMatch;
    }

    private static boolean isParamMatch(Class<?>[] actualParams, Class<?> wantedParam) {
        if (actualParams != null && wantedParam != null && actualParams.length > 0) {
            for (Class<?> actualArg : actualParams) {
                if (!actualArg.isAssignableFrom(wantedParam)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private static boolean isPathRegexMatch(ClassCriteria classCriteria, File file) {
        String filePath = file.getAbsolutePath();
        for (String pathRegex : classCriteria.getExcludePathRegex()) {
            Matcher matcher = Pattern.compile(pathRegex).matcher(filePath);
            if (!matcher.find()) continue;
            LOGGER.trace("Search criteria specifies to exclude paths containing regex {}, so skipping path {}", (Object)pathRegex, (Object)filePath);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

