/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import no.acntech.common.test.BasicType;
import no.acntech.common.test.ObjectInstantiationException;
import no.acntech.common.test.TestReflectionUtils;
import org.easymock.EasyMock;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestTypeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestTypeFactory.class);
    private static final List<BasicType> BASIC_TYPES = new ArrayList<BasicType>();

    private TestTypeFactory() {
    }

    public static void addBasicType(BasicType basicType) {
        BASIC_TYPES.add(basicType);
    }

    public static <T> T createType(Class<T> clazz) throws InstantiationException {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        T object = TestTypeFactory.createBasicType(clazz);
        if (object != null) {
            return object;
        }
        object = TestTypeFactory.createMockTypeWithMockito(clazz);
        if (object != null) {
            return object;
        }
        object = TestTypeFactory.createMockTypeWithEasyMock(clazz);
        if (object != null) {
            return object;
        }
        object = TestTypeFactory.createBeanType(clazz);
        if (object != null) {
            return object;
        }
        throw new ObjectInstantiationException(clazz);
    }

    private static <T> T createBasicType(Class<T> clazz) {
        for (BasicType basicType : BASIC_TYPES) {
            if (!basicType.isType(clazz)) continue;
            return basicType.getType(clazz);
        }
        return null;
    }

    private static <T> T createMockTypeWithMockito(Class<T> clazz) {
        if (TestReflectionUtils.isFinalClass(clazz)) {
            LOGGER.warn("Can not mock final classes with Mockito");
            return null;
        }
        if (!TestReflectionUtils.isClassExists(Mockito.class, TestTypeFactory.class.getClassLoader())) {
            LOGGER.warn("Can not find Mockito on classpath");
            return null;
        }
        return (T)Mockito.mock(clazz);
    }

    private static <T> T createMockTypeWithEasyMock(Class<T> clazz) {
        if (TestReflectionUtils.isFinalClass(clazz)) {
            LOGGER.warn("Can not mock final classes with EasyMock");
            return null;
        }
        if (!TestReflectionUtils.isClassExists(EasyMock.class, TestTypeFactory.class.getClassLoader())) {
            LOGGER.warn("Can not find EasyMock on classpath");
            return null;
        }
        return (T)EasyMock.mock(clazz);
    }

    private static <T> T createBeanType(Class<T> clazz) throws InstantiationException {
        try {
            return TestReflectionUtils.createBean(clazz, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to create bean from class " + clazz.getName(), (Throwable)e);
            return null;
        }
    }

    static Class<?>[] getClassesForObjects(Object ... objects) {
        if (objects == null) {
            return new Class[0];
        }
        Class[] argClasses = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            argClasses[i] = objects[i].getClass();
        }
        return argClasses;
    }

    private static void populateBasicTypes() {
        TestTypeFactory.addBasicType(new BasicType<Object>(){

            @Override
            public boolean isType(Class<Object> clazz) {
                return Object.class == clazz;
            }

            @Override
            public Object getType(Class<Object> clazz) {
                return new Object();
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Class>(){

            @Override
            public boolean isType(Class<Class> clazz) {
                return Class.class == clazz;
            }

            @Override
            public Class getType(Class<Class> clazz) {
                return clazz;
            }
        });
        TestTypeFactory.addBasicType(new BasicType<String>(){

            @Override
            public boolean isType(Class<String> clazz) {
                return String.class.isAssignableFrom(clazz);
            }

            @Override
            public String getType(Class<String> clazz) {
                return "whatever";
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Boolean>(){

            @Override
            public boolean isType(Class<Boolean> clazz) {
                return Boolean.TYPE == clazz || Boolean.class.isAssignableFrom(clazz);
            }

            @Override
            public Boolean getType(Class<Boolean> clazz) {
                return Boolean.TRUE;
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Integer>(){

            @Override
            public boolean isType(Class<Integer> clazz) {
                return Integer.TYPE == clazz || Integer.class.isAssignableFrom(clazz);
            }

            @Override
            public Integer getType(Class<Integer> clazz) {
                return 1337;
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Long>(){

            @Override
            public boolean isType(Class<Long> clazz) {
                return Long.TYPE == clazz || Long.class.isAssignableFrom(clazz);
            }

            @Override
            public Long getType(Class<Long> clazz) {
                return 1337L;
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Double>(){

            @Override
            public boolean isType(Class<Double> clazz) {
                return Double.TYPE == clazz || Double.class.isAssignableFrom(clazz);
            }

            @Override
            public Double getType(Class<Double> clazz) {
                return 13.37;
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Float>(){

            @Override
            public boolean isType(Class<Float> clazz) {
                return Float.TYPE == clazz || Float.class.isAssignableFrom(clazz);
            }

            @Override
            public Float getType(Class<Float> clazz) {
                return Float.valueOf(13.37f);
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Character>(){

            @Override
            public boolean isType(Class<Character> clazz) {
                return Character.TYPE == clazz || Character.class.isAssignableFrom(clazz);
            }

            @Override
            public Character getType(Class<Character> clazz) {
                return Character.valueOf('Y');
            }
        });
        TestTypeFactory.addBasicType(new BasicType<List>(){

            @Override
            public boolean isType(Class<List> clazz) {
                return List.class.isAssignableFrom(clazz);
            }

            @Override
            public List<?> getType(Class<List> clazz) {
                return new ArrayList();
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Object>(){

            @Override
            public boolean isType(Class<Object> clazz) {
                return clazz.isArray();
            }

            @Override
            public Object getType(Class<Object> clazz) {
                return Array.newInstance(clazz.getComponentType(), 1);
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Object>(){

            @Override
            public boolean isType(Class<Object> clazz) {
                return clazz.isEnum();
            }

            @Override
            public Object getType(Class<Object> clazz) {
                return clazz.getEnumConstants()[0];
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Date>(){

            @Override
            public boolean isType(Class<Date> clazz) {
                return Date.class.isAssignableFrom(clazz);
            }

            @Override
            public Date getType(Class<Date> clazz) {
                return new Date(System.currentTimeMillis());
            }
        });
        TestTypeFactory.addBasicType(new BasicType<Calendar>(){

            @Override
            public boolean isType(Class<Calendar> clazz) {
                return Calendar.class.isAssignableFrom(clazz);
            }

            @Override
            public Calendar getType(Class<Calendar> clazz) {
                return Calendar.getInstance();
            }
        });
    }

    static {
        TestTypeFactory.populateBasicTypes();
    }
}

