/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import no.acntech.common.test.BasicType;
import no.acntech.common.test.TestReflectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AdvancedTestTypeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvancedTestTypeFactory.class);
    private static final List<BasicType> TYPES = new ArrayList<BasicType>();

    private AdvancedTestTypeFactory() {
    }

    static <T> T createType(Class<T> clazz) throws InstantiationException {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null");
        }
        for (BasicType type : TYPES) {
            if (!type.isType(clazz)) continue;
            return type.getType(clazz);
        }
        return null;
    }

    private static void addType(BasicType type) {
        TYPES.add(type);
    }

    private static void populateTypes() {
        AdvancedTestTypeFactory.populateJavaTimeTypes();
        AdvancedTestTypeFactory.populateJodaTimeTypes();
    }

    private static void populateJavaTimeTypes() {
        if (TestReflectionUtils.isClassExists("java.time.LocalDate", AdvancedTestTypeFactory.class.getClassLoader())) {
            AdvancedTestTypeFactory.addType(new BasicType<java.time.LocalTime>(){

                @Override
                public boolean isType(Class<java.time.LocalTime> clazz) {
                    return java.time.LocalTime.class.isAssignableFrom(clazz);
                }

                @Override
                public java.time.LocalTime getType(Class<java.time.LocalTime> clazz) {
                    return java.time.LocalTime.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<LocalDate>(){

                @Override
                public boolean isType(Class<LocalDate> clazz) {
                    return LocalDate.class.isAssignableFrom(clazz);
                }

                @Override
                public LocalDate getType(Class<LocalDate> clazz) {
                    return LocalDate.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<java.time.LocalDateTime>(){

                @Override
                public boolean isType(Class<java.time.LocalDateTime> clazz) {
                    return java.time.LocalDateTime.class.isAssignableFrom(clazz);
                }

                @Override
                public java.time.LocalDateTime getType(Class<java.time.LocalDateTime> clazz) {
                    return java.time.LocalDateTime.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<ZonedDateTime>(){

                @Override
                public boolean isType(Class<ZonedDateTime> clazz) {
                    return ZonedDateTime.class.isAssignableFrom(clazz);
                }

                @Override
                public ZonedDateTime getType(Class<ZonedDateTime> clazz) {
                    return ZonedDateTime.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<OffsetTime>(){

                @Override
                public boolean isType(Class<OffsetTime> clazz) {
                    return OffsetTime.class.isAssignableFrom(clazz);
                }

                @Override
                public OffsetTime getType(Class<OffsetTime> clazz) {
                    return OffsetTime.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<Period>(){

                @Override
                public boolean isType(Class<Period> clazz) {
                    return Period.class.isAssignableFrom(clazz);
                }

                @Override
                public Period getType(Class<Period> clazz) {
                    return Period.ofDays(1337);
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<java.time.Duration>(){

                @Override
                public boolean isType(Class<java.time.Duration> clazz) {
                    return java.time.Duration.class.isAssignableFrom(clazz);
                }

                @Override
                public java.time.Duration getType(Class<java.time.Duration> clazz) {
                    return java.time.Duration.ofDays(1337L);
                }
            });
        } else {
            LOGGER.debug("Classes for Java Time (JSR-310) could not be found on classpath. Possibly running JVM version < 1.8");
        }
    }

    private static void populateJodaTimeTypes() {
        if (TestReflectionUtils.isClassExists("org.joda.time.LocalDate", AdvancedTestTypeFactory.class.getClassLoader())) {
            AdvancedTestTypeFactory.addType(new BasicType<LocalTime>(){

                @Override
                public boolean isType(Class<LocalTime> clazz) {
                    return LocalTime.class.isAssignableFrom(clazz);
                }

                @Override
                public LocalTime getType(Class<LocalTime> clazz) {
                    return LocalTime.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<org.joda.time.LocalDate>(){

                @Override
                public boolean isType(Class<org.joda.time.LocalDate> clazz) {
                    return org.joda.time.LocalDate.class.isAssignableFrom(clazz);
                }

                @Override
                public org.joda.time.LocalDate getType(Class<org.joda.time.LocalDate> clazz) {
                    return org.joda.time.LocalDate.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<LocalDateTime>(){

                @Override
                public boolean isType(Class<LocalDateTime> clazz) {
                    return LocalDateTime.class.isAssignableFrom(clazz);
                }

                @Override
                public LocalDateTime getType(Class<LocalDateTime> clazz) {
                    return LocalDateTime.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<DateTime>(){

                @Override
                public boolean isType(Class<DateTime> clazz) {
                    return DateTime.class.isAssignableFrom(clazz);
                }

                @Override
                public DateTime getType(Class<DateTime> clazz) {
                    return DateTime.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<Instant>(){

                @Override
                public boolean isType(Class<Instant> clazz) {
                    return Instant.class.isAssignableFrom(clazz);
                }

                @Override
                public Instant getType(Class<Instant> clazz) {
                    return Instant.now();
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<org.joda.time.Period>(){

                @Override
                public boolean isType(Class<org.joda.time.Period> clazz) {
                    return org.joda.time.Period.class.isAssignableFrom(clazz);
                }

                @Override
                public org.joda.time.Period getType(Class<org.joda.time.Period> clazz) {
                    return org.joda.time.Period.days((int)1337);
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<Duration>(){

                @Override
                public boolean isType(Class<Duration> clazz) {
                    return Duration.class.isAssignableFrom(clazz);
                }

                @Override
                public Duration getType(Class<Duration> clazz) {
                    return Duration.standardDays((long)1337L);
                }
            });
            AdvancedTestTypeFactory.addType(new BasicType<Interval>(){

                @Override
                public boolean isType(Class<Interval> clazz) {
                    return Interval.class.isAssignableFrom(clazz);
                }

                @Override
                public Interval getType(Class<Interval> clazz) {
                    return Interval.parse((String)"1970-01-01T00:00:00");
                }
            });
        } else {
            LOGGER.debug("Classes for Joda-Time API could not be found on classpath");
        }
    }

    static {
        AdvancedTestTypeFactory.populateTypes();
    }
}

