/*
 * Decompiled with CFR 0.152.
 */
package no.acntech.common.test;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FieldCriteria {
    public static final String INTERNAL_CLASS_FIELD = "class";
    private Set<String> excludeFields;

    private FieldCriteria() {
    }

    public Set<String> getExcludeFields() {
        if (this.excludeFields == null) {
            this.excludeFields = new HashSet<String>();
        }
        this.excludeFields.add(INTERNAL_CLASS_FIELD);
        return this.excludeFields;
    }

    public static Builder createDefault() {
        return new Builder(new FieldCriteria());
    }

    public static class Builder {
        private FieldCriteria fieldCriteria;

        private Builder(FieldCriteria fieldCriteria) {
            if (fieldCriteria == null) {
                throw new IllegalArgumentException("Field criteria is null");
            }
            this.fieldCriteria = fieldCriteria;
        }

        public Builder doExcludeFields(String ... fields) {
            if (this.fieldCriteria.excludeFields == null) {
                this.fieldCriteria.excludeFields = new HashSet();
            }
            if (fields != null) {
                this.fieldCriteria.excludeFields.addAll(Arrays.asList(fields));
            }
            return this;
        }

        public Builder doIncludeFields(String ... fields) {
            if (this.fieldCriteria.excludeFields == null) {
                this.fieldCriteria.excludeFields = new HashSet();
            }
            if (fields != null) {
                this.fieldCriteria.excludeFields.removeAll(Arrays.asList(fields));
            }
            return this;
        }

        public FieldCriteria build() {
            return this.fieldCriteria;
        }
    }
}

