/*
 * Decompiled with CFR 0.152.
 */
package no.api.freemarker.java8.time;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import no.api.freemarker.java8.time.AbstractAdapter;
import no.api.freemarker.java8.time.AbstractChecker;
import no.api.freemarker.java8.time.AbstractFormatter;
import no.api.freemarker.java8.time.DateTimeTools;

public class LocalDateTimeAdapter
extends AbstractAdapter<LocalDateTime>
implements AdapterTemplateModel,
TemplateScalarModel,
TemplateHashModel {
    public LocalDateTimeAdapter(LocalDateTime obj) {
        super(obj);
    }

    public TemplateModel get(String s) throws TemplateModelException {
        if ("format".equals(s)) {
            return new LocalDateTimeFormatter((LocalDateTime)this.getObject());
        }
        if ("isEqual".equals(s) || "isAfter".equals(s) || "isBefore".equals(s)) {
            return new LocalDateTimeChecker((LocalDateTime)this.getObject(), s);
        }
        throw new TemplateModelException("Unknown method call: " + s);
    }

    public class LocalDateTimeChecker
    extends AbstractChecker<LocalDateTime>
    implements TemplateMethodModelEx {
        private String method;

        public LocalDateTimeChecker(LocalDateTime obj, String method) {
            super(obj);
            this.method = method;
        }

        public Object exec(List list) throws TemplateModelException {
            LocalDateTimeAdapter adapter = (LocalDateTimeAdapter)((Object)list.get(0));
            switch (this.method) {
                case "isEqual": {
                    return ((LocalDateTime)this.getObject()).isEqual((ChronoLocalDateTime)adapter.getObject());
                }
                case "isAfter": {
                    return ((LocalDateTime)this.getObject()).isAfter((ChronoLocalDateTime)adapter.getObject());
                }
                case "isBefore": {
                    return ((LocalDateTime)this.getObject()).isBefore((ChronoLocalDateTime)adapter.getObject());
                }
            }
            throw new TemplateModelException("method not implemented");
        }
    }

    public class LocalDateTimeFormatter
    extends AbstractFormatter<LocalDateTime>
    implements TemplateMethodModelEx {
        public LocalDateTimeFormatter(LocalDateTime obj) {
            super(obj);
        }

        public Object exec(List list) throws TemplateModelException {
            return ((LocalDateTime)this.getObject()).format(DateTimeTools.createDateTimeFormatter(list, 0, DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
    }
}

