/*
 * Decompiled with CFR 0.152.
 */
package no.api.freemarker.java8.time;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Field;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.zone.ZoneRulesException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import no.api.freemarker.java8.time.ExtFormatStyle;
import no.api.freemarker.java8.time.PreparedFormatStyle;

public final class DateTimeTools {
    public static final String METHOD_EQUALS = "isEqual";
    public static final String METHOD_BEFORE = "isBefore";
    public static final String METHOD_AFTER = "isAfter";
    public static final String METHOD_FORMAT = "format";
    public static final String METHOD_DAYS = "days";
    public static final String METHOD_MONTHS = "months";
    public static final String METHOD_YEARS = "years";
    public static final String METHOD_NANO = "nano";
    public static final String METHOD_SECONDS = "seconds";
    public static final String METHOD_AS_ZONE_DATETIME = "toZonedDateTime";
    public static final String METHOD_UNKNOWN_MSG = "Unknown method call: ";
    public static final String ILLEGAL_ZONE_ID_MSG = "Illegal Zone ID";

    private DateTimeTools() {
        throw new UnsupportedOperationException();
    }

    public static DateTimeFormatter createDateTimeFormatter(List list, int index, DateTimeFormatter defaultFormatter) {
        if (list.size() > 0) {
            String format = ((SimpleScalar)list.get(index)).getAsString();
            ExtFormatStyle style = DateTimeTools.getFormatStyle(format);
            if (style != null) {
                return style.getFormatter().withLocale(DateTimeTools.getLocale());
            }
            Optional<DateTimeFormatter> builtin = DateTimeTools.getJreBuiltinFormatter(format);
            return builtin.orElseGet(() -> DateTimeFormatter.ofPattern(format, DateTimeTools.getLocale()));
        }
        return defaultFormatter.withLocale(DateTimeTools.getLocale());
    }

    public static DateTimeFormatter createDateTimeFormatter(List list, int index, String defaultPattern) {
        return DateTimeFormatter.ofPattern(list.size() > index ? ((SimpleScalar)list.get(index)).getAsString() : defaultPattern, DateTimeTools.getLocale());
    }

    public static Optional<ZoneId> zoneIdLookup(List list, int index) throws TemplateModelException {
        if (list.size() > index) {
            String zoneIdString = ((SimpleScalar)list.get(index)).getAsString();
            try {
                return Optional.of(ZoneId.of(zoneIdString));
            }
            catch (ZoneRulesException e) {
                throw new TemplateModelException(ILLEGAL_ZONE_ID_MSG, (Exception)e);
            }
        }
        return Optional.empty();
    }

    private static Locale getLocale() {
        if (Environment.getCurrentEnvironment() != null) {
            return Environment.getCurrentEnvironment().getLocale();
        }
        return Locale.getDefault();
    }

    private static ExtFormatStyle getFormatStyle(String format) {
        try {
            return PreparedFormatStyle.valueOf(format);
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            return null;
        }
    }

    private static Optional<DateTimeFormatter> getJreBuiltinFormatter(String name) {
        try {
            Field dateTimeFormatterField = DateTimeFormatter.class.getField(name);
            if ((dateTimeFormatterField.getModifiers() & 8) != 0 && DateTimeFormatter.class.isAssignableFrom(dateTimeFormatterField.getType())) {
                return Optional.ofNullable((DateTimeFormatter)dateTimeFormatterField.get(null));
            }
            return Optional.empty();
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Field \"" + name + "\" has modifier STATIC but seems to be not static!", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Not allowed to access Field \"" + name + "\" of class " + DateTimeFormatter.class, e);
        }
    }
}

