/*
 * Decompiled with CFR 0.152.
 */
package no.api.freemarker.java8.time;

import freemarker.template.SimpleNumber;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.List;
import no.api.freemarker.java8.time.AbstractMutator;

public class TemporalDialer
extends AbstractMutator<Temporal>
implements TemplateMethodModelEx {
    private final TemporalUnit temporalUnit;

    public TemporalDialer(Temporal obj, TemporalUnit temporalUnit) {
        super(obj);
        this.temporalUnit = temporalUnit;
    }

    public Object exec(List list) throws TemplateModelException {
        return ((Temporal)this.getObject()).plus(this.parseLong(list.get(0)), this.temporalUnit);
    }

    private long parseLong(Object o) throws TemplateModelException {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof SimpleNumber) {
            return ((SimpleNumber)o).getAsNumber().longValue();
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new TemplateModelException("Invalid number: '" + o + "'");
    }
}

