/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import no.api.meteo.client.MeteoClient;
import no.api.meteo.client.MeteoClientException;
import no.api.meteo.client.MeteoResponse;
import no.api.meteo.client.MeteoResponseHeader;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMeteoClient
implements MeteoClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMeteoClient.class);
    public static final int MAXIMUM_CONTENT_LENGTH = 1024000;
    public static final String CAUGHT_EXCEPTION_WHILE_FETCHING_CONTENT = "Caught exception while fetching content";
    private final DefaultHttpClient httpClient;

    public DefaultMeteoClient() {
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());
    }

    public DefaultMeteoClient(int timeout) {
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(SchemeRegistryFactory.createDefault(), (long)timeout, TimeUnit.SECONDS));
    }

    public void setProxy(String hostname, int port) {
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(hostname, port));
    }

    public void setTimeout(int timeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpClient.getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpClient.getParams(), (int)timeout);
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    public MeteoResponse fetchContent(URI uri) throws MeteoClientException {
        try {
            log.debug("Going to fetch: " + uri.toString());
            HttpGet httpget = new HttpGet(uri);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 203) {
                throw new MeteoClientException("The request failed with error code " + response.getStatusLine().getStatusCode() + " : " + response.getStatusLine().getReasonPhrase());
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                MeteoResponse meteoResponse = new MeteoResponse(EntityUtils.toString((HttpEntity)entity), this.createMeteoResponseHeaders((HttpResponse)response), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
                return meteoResponse;
            }
            try {
                throw new MeteoClientException("No content returned from request: " + uri.toString());
            }
            catch (IOException e) {
                throw new MeteoClientException(CAUGHT_EXCEPTION_WHILE_FETCHING_CONTENT, (Throwable)e);
            }
        }
        finally {
            this.httpClient.getConnectionManager().closeExpiredConnections();
        }
    }

    private List<MeteoResponseHeader> createMeteoResponseHeaders(HttpResponse response) {
        ArrayList<MeteoResponseHeader> headers = new ArrayList<MeteoResponseHeader>();
        for (Header header : response.getAllHeaders()) {
            log.debug("Adding header : " + header.toString());
            headers.add(new MeteoResponseHeader(header.getName(), header.getValue()));
        }
        return headers;
    }
}

