/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.entity.core.service.sunrise;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import no.api.meteo.entity.core.Location;
import no.api.meteo.entity.core.Meta;
import no.api.meteo.entity.core.RootEntity;
import no.api.meteo.entity.core.service.sunrise.SunriseDate;

public final class Sunrise
extends RootEntity {
    @JsonProperty
    private final Location location;
    @JsonProperty
    private final List<SunriseDate> dates;

    @JsonCreator
    public Sunrise(@JsonProperty(value="created") Date created, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="location") Location location, @JsonProperty(value="dates") List<SunriseDate> dates) {
        super(created, meta);
        this.location = location;
        this.dates = dates;
    }

    public List<SunriseDate> getDates() {
        return this.dates == null ? new ArrayList() : Collections.unmodifiableList(this.dates);
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public String toString() {
        return "Sunrise(super=" + super.toString() + ", location=" + this.getLocation() + ", dates=" + this.getDates() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sunrise)) {
            return false;
        }
        Sunrise other = (Sunrise)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        List<SunriseDate> this$dates = this.getDates();
        List<SunriseDate> other$dates = other.getDates();
        return !(this$dates == null ? other$dates != null : !((Object)this$dates).equals(other$dates));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Sunrise;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 0 : ((Object)$location).hashCode());
        List<SunriseDate> $dates = this.getDates();
        result = result * 59 + ($dates == null ? 0 : ((Object)$dates).hashCode());
        return result;
    }
}

