/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.entity.extras;

import no.api.meteo.entity.extras.BeaufortRange;

public enum BeaufortLevel {
    CALM(0, "Calm", "Stille", new BeaufortRange(0.0, 0.2), new BeaufortRange(0.0, 1.0), new BeaufortRange(0.0, 1.0)),
    LIGHT_AIR(1, "Light air", "Flau vind", new BeaufortRange(0.3, 1.5), new BeaufortRange(1.0, 5.0), new BeaufortRange(1.0, 3.0)),
    LIGHT_BREEZE(2, "Light breeze", "Svak vind", new BeaufortRange(1.6, 3.3), new BeaufortRange(6.0, 11.0), new BeaufortRange(4.0, 6.0)),
    GENTLE_BREEZE(3, "Gentle breeze", "Lett bris", new BeaufortRange(3.4, 5.4), new BeaufortRange(12.0, 19.0), new BeaufortRange(7.0, 10.0)),
    MODERATE_BREEZE(4, "Moderate breeze", "Laber bris", new BeaufortRange(5.5, 7.9), new BeaufortRange(20.0, 28.0), new BeaufortRange(11.0, 16.0)),
    FRESH_BREEZE(5, "Fresh breeze", "Frisk bris", new BeaufortRange(8.0, 10.7), new BeaufortRange(29.0, 38.0), new BeaufortRange(17.0, 21.0)),
    STRONG_BREEZE(6, "Strong breeze", "Liten kuling", new BeaufortRange(10.8, 13.8), new BeaufortRange(39.0, 49.0), new BeaufortRange(22.0, 27.0)),
    NEAR_GALE(7, "High wind, Moderate gale, Near gale", "Stiv kuling", new BeaufortRange(13.9, 17.1), new BeaufortRange(50.0, 61.0), new BeaufortRange(28.0, 33.0)),
    FRESH_GALE(8, "Gale, Fresh gale", "Sterk kuling", new BeaufortRange(17.2, 20.7), new BeaufortRange(62.0, 74.0), new BeaufortRange(34.0, 40.0)),
    STRONG_GALE(9, "Strong gale", "Liten storm", new BeaufortRange(20.8, 24.4), new BeaufortRange(75.0, 88.0), new BeaufortRange(41.0, 47.0)),
    STORM(10, "Storm, Whole gale", "Full storm", new BeaufortRange(24.5, 28.4), new BeaufortRange(89.0, 102.0), new BeaufortRange(48.0, 55.0)),
    VIOLENT_STORM(11, "Violent storm", "Sterk storm", new BeaufortRange(28.5, 32.6), new BeaufortRange(103.0, 117.0), new BeaufortRange(56.0, 63.0)),
    HURRICANE_FORCE(12, "Hurrican-force", "Orkan", new BeaufortRange(32.7, 36.9), new BeaufortRange(118.0, Double.MAX_VALUE), new BeaufortRange(64.0, Double.MAX_VALUE));

    private final int id;
    private final String nameEN;
    private final String nameNO;
    private final BeaufortRange ms;
    private final BeaufortRange kmh;
    private final BeaufortRange kn;

    private BeaufortLevel(int id, String nameEN, String nameNO, BeaufortRange ms, BeaufortRange kmh, BeaufortRange kn) {
        this.nameEN = nameEN;
        this.nameNO = nameNO;
        this.id = id;
        this.ms = ms;
        this.kmh = kmh;
        this.kn = kn;
    }

    public BeaufortRange getKmhRange() {
        return this.kmh;
    }

    public BeaufortRange getKnRange() {
        return this.kn;
    }

    public BeaufortRange getMsRange() {
        return this.ms;
    }

    public String getNameEN() {
        return this.nameEN;
    }

    public String getNameNO() {
        return this.nameNO;
    }

    public int getId() {
        return this.id;
    }

    public static BeaufortLevel findUnitByMetersPerSecond(double value) {
        for (BeaufortLevel beaufortLevel : BeaufortLevel.values()) {
            if (!(value >= beaufortLevel.getMsRange().getStart()) || !(value <= beaufortLevel.getMsRange().getStop())) continue;
            return beaufortLevel;
        }
        return BeaufortLevel.getLevelOutsideRange(value, CALM.getMsRange().getStart());
    }

    public static BeaufortLevel findUnitByKnots(double value) {
        for (BeaufortLevel beaufortLevel : BeaufortLevel.values()) {
            if (!(value >= beaufortLevel.getKnRange().getStart()) || !(value <= beaufortLevel.getKnRange().getStop())) continue;
            return beaufortLevel;
        }
        return BeaufortLevel.getLevelOutsideRange(value, CALM.getKnRange().getStart());
    }

    public static BeaufortLevel findUnitByKilometersPerHour(double value) {
        for (BeaufortLevel beaufortLevel : BeaufortLevel.values()) {
            if (!(value >= beaufortLevel.getKmhRange().getStart()) || !(value <= beaufortLevel.getKmhRange().getStop())) continue;
            return beaufortLevel;
        }
        return BeaufortLevel.getLevelOutsideRange(value, CALM.getKmhRange().getStart());
    }

    public static BeaufortLevel findUnitById(int value) {
        for (BeaufortLevel beaufortLevel : BeaufortLevel.values()) {
            if (value != beaufortLevel.getId()) continue;
            return beaufortLevel;
        }
        if (value < 0) {
            return CALM;
        }
        return HURRICANE_FORCE;
    }

    private static BeaufortLevel getLevelOutsideRange(double value, double startValue) {
        if (value < startValue) {
            return CALM;
        }
        return HURRICANE_FORCE;
    }
}

